/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.gc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.gc.GCSample;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class GCSamples
implements Serializable {
    private static final long serialVersionUID = -4311672413828550701L;
    private final List samples = new ArrayList();

    public final void add(GCSample sample) {
        this.samples.add(sample);
    }

    public final int getSampleCount() {
        return this.samples.size();
    }

    public final double getTimeStampForSampleAt(int index) {
        return ((GCSample)this.samples.get(index)).getTimestamp();
    }

    public final void extractHeapBefore(TimeSeries heapBeforeSeries) {
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            GCSample sample = (GCSample)it.next();
            heapBeforeSeries.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), (double)sample.getHeapBefore());
        }
    }

    public final void extractHeapAfter(TimeSeries heapAfterSeries) {
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            GCSample sample = (GCSample)it.next();
            heapAfterSeries.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), (double)sample.getHeapAfter());
        }
    }

    public final void extractHeapTotal(TimeSeries heapTotalSeries) {
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            GCSample sample = (GCSample)it.next();
            heapTotalSeries.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), (double)sample.getHeapTotal());
        }
    }

    public final void extractProcessingTime(TimeSeries series) {
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            GCSample sample = (GCSample)it.next();
            series.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), sample.getProcessingTime());
        }
    }

    public final double getGarbageCollectionRatio(long totalTime) {
        double totalProcessing = 0.0;
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            GCSample sample = (GCSample)it.next();
            totalProcessing += sample.getProcessingTime();
        }
        return totalProcessing / (double)totalTime;
    }

    public final double getCollectedKBPerSecond(long totalTime) {
        double totalCollected = 0.0;
        Iterator it = this.samples.iterator();
        while (it.hasNext()) {
            GCSample sample = (GCSample)it.next();
            totalCollected += (double)(sample.getHeapBefore() - sample.getHeapAfter());
        }
        return totalCollected / 1000.0 / (double)totalTime;
    }

    private Millisecond getTimestamp(GCSample sample) {
        int milliseconds = (int)(sample.getTimestamp() * 1000.0);
        return Utils.createMS(milliseconds);
    }
}

