/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.gc;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.mojo.chronos.gc.GCSample;
import org.codehaus.mojo.chronos.gc.GCSamples;

public class GCLogParser {
    public GCSamples parseGCLog(String gcFilePath) throws IOException {
        File gcFile = new File(gcFilePath);
        return this.parseGCLog(gcFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GCSamples parseGCLog(File gcFile) throws IOException {
        FileReader fileReader = new FileReader(gcFile);
        GCSamples samples = new GCSamples();
        LineNumberReader reader = new LineNumberReader(fileReader);
        StringBuffer concatLines = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                concatLines.append(line);
                if (line.indexOf("]") <= -1) continue;
                samples.add(this.parseGCLogItem(concatLines.toString()));
                concatLines.setLength(0);
            }
            GCSamples gCSamples = samples;
            return gCSamples;
        }
        finally {
            reader.close();
        }
    }

    private GCSample parseGCLogItem(String source) {
        String timeinstant = null;
        String heapbefore = null;
        String heapafter = null;
        String totalheap = null;
        String processingtime = null;
        Pattern pattern = Pattern.compile("[0-9]*\\.[0-9]*:|[0-9]*K|[0-9]*\\.[0-9]*");
        Matcher matcher = pattern.matcher(source);
        int index = 0;
        while (matcher.find()) {
            if (matcher.group().length() <= 0) continue;
            switch (index) {
                case 0: {
                    timeinstant = matcher.group();
                    timeinstant = timeinstant.substring(0, timeinstant.length() - 1);
                    break;
                }
                case 1: {
                    heapbefore = matcher.group();
                    heapbefore = heapbefore.substring(0, heapbefore.length() - 1);
                    break;
                }
                case 2: {
                    heapafter = matcher.group();
                    heapafter = heapafter.substring(0, heapafter.length() - 1);
                    break;
                }
                case 3: {
                    totalheap = matcher.group();
                    totalheap = totalheap.substring(0, totalheap.length() - 1);
                    break;
                }
                case 4: {
                    processingtime = matcher.group();
                    processingtime = matcher.group();
                }
            }
            ++index;
        }
        return new GCSample(Double.parseDouble(timeinstant), Integer.parseInt(heapbefore), Integer.parseInt(heapafter), Integer.parseInt(totalheap), Double.parseDouble(processingtime));
    }
}

