/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.chart.ChartSource;
import org.codehaus.mojo.chronos.chart.ChartUtil;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class SummaryThroughputChartSource
implements ChartSource {
    private ResponsetimeSamples samples;
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    public SummaryThroughputChartSource(ResponsetimeSamples samples) {
        this.samples = samples;
    }

    public boolean isEnabled(ResourceBundle bundle, ReportConfig config) {
        return config.isShowthroughput() && config.isShowsummary();
    }

    public String getFileName(ResourceBundle bundle, ReportConfig config) {
        return "throughput-" + config.getId();
    }

    public JFreeChart getChart(ResourceBundle bundle, ReportConfig config) {
        XYPlot throughputPlot = this.createThroughputPlot(bundle, config);
        XYPlot threadCountPlot = this.createThreadCountPlot(bundle, config);
        String label = bundle.getString("chronos.label.throughput.time");
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        DateAxis timeAxis = ChartUtil.createTimeAxis(label, dateFormat);
        CombinedDomainXYPlot combineddomainxyplot = ChartUtil.createCombinedPlot(timeAxis, throughputPlot, threadCountPlot);
        return new JFreeChart(bundle.getString("chronos.label.throughput"), (Plot)combineddomainxyplot);
    }

    private XYPlot createThroughputPlot(ResourceBundle bundle, ReportConfig config) {
        TimeSeriesCollection dataset1 = this.createThroughputDataset(bundle, config);
        XYPlot throughputPlot = ChartUtil.newPlot((XYDataset)dataset1, bundle.getString("chronos.label.throughput.requests"), true);
        throughputPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        throughputPlot.getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        throughputPlot.getRenderer().setSeriesPaint(1, (Paint)Color.BLUE);
        throughputPlot.setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        double maxAvgThroughput = this.samples.getMaxAverageThroughput(config.getAverageduration(), config.getResponsetimedivider());
        String maxThroughputLabel = bundle.getString("chronos.label.maxaveragethroughput");
        ChartUtil.addRangeMarker(throughputPlot, maxThroughputLabel, maxAvgThroughput);
        return throughputPlot;
    }

    private TimeSeriesCollection createThroughputDataset(ResourceBundle bundle, ReportConfig config) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries series = this.samples.createMovingThroughput(bundle.getString("chronos.label.throughput"), config.getResponsetimedivider());
        dataset.addSeries(series);
        int avgDuration = config.getAverageduration();
        String label = bundle.getString("chronos.label.average");
        TimeSeries averageseries = MovingAverage.createMovingAverage((TimeSeries)series, (String)label, (int)avgDuration, (int)0);
        dataset.addSeries(averageseries);
        return dataset;
    }

    private XYPlot createThreadCountPlot(ResourceBundle bundle, ReportConfig config) {
        TimeSeriesCollection dataset2 = this.createThreadCountdataset(bundle, config);
        XYPlot threadCountPlot = ChartUtil.newPlot((XYDataset)dataset2, bundle.getString("chronos.label.threadcount.y"), false);
        threadCountPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        threadCountPlot.getRenderer().setSeriesPaint(0, (Paint)Color.GRAY);
        return threadCountPlot;
    }

    private TimeSeriesCollection createThreadCountdataset(ResourceBundle bundle, ReportConfig config) {
        TimeSeries series = new TimeSeries((Comparable)((Object)bundle.getString("chronos.label.threadcount")), class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = SummaryThroughputChartSource.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        this.samples.appendThreadCounts(series, config.getThreadcountduration());
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

