/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.chart.ChartSource;
import org.codehaus.mojo.chronos.chart.ChartUtil;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class SummaryGCChartSource
implements ChartSource {
    private GCSamples samples;
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    public SummaryGCChartSource(GCSamples samples) {
        this.samples = samples;
    }

    public boolean isEnabled(ResourceBundle bundle, ReportConfig config) {
        return config.isShowgc() && config.isShowsummary();
    }

    public String getFileName(ResourceBundle bundle, ReportConfig config) {
        return "gc-" + config.getId();
    }

    public JFreeChart getChart(ResourceBundle bundle, ReportConfig config) {
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        TimeSeries heapBeforeSeries = new TimeSeries((Comparable)((Object)bundle.getString("chronos.label.gc.before")), class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = SummaryGCChartSource.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        this.samples.extractHeapBefore(heapBeforeSeries);
        TimeSeries heapAfterSeries = new TimeSeries((Comparable)((Object)bundle.getString("chronos.label.gc.after")), class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = SummaryGCChartSource.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        this.samples.extractHeapAfter(heapAfterSeries);
        dataset1.addSeries(heapBeforeSeries);
        dataset1.addSeries(heapAfterSeries);
        TimeSeriesCollection dataset = dataset1;
        String title = bundle.getString("chronos.label.gc");
        String timeLabel = bundle.getString("chronos.label.gc.time");
        String valueLabel = bundle.getString("chronos.label.gc.mem");
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)timeLabel, (String)valueLabel, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        ChartUtil.setupXYPlot(chart, new SimpleDateFormat("HH:mm:ss"));
        return chart;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

