/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.chart.ChartUtil;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ResponseChartGenerator {
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    protected JFreeChart createResponseChart(String datasetName, ResponsetimeSamples samples, ResourceBundle bundle, ReportConfig config) {
        String text;
        TimeSeriesCollection dataset = this.createResponseDataset(datasetName, samples, bundle, config);
        String title = bundle.getString("chronos.label.responsetimes");
        String timeAxisLabel = bundle.getString("chronos.label.responsetimes.time");
        String valueAxisLabel = bundle.getString("chronos.label.responsetimes.responsetime");
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        ChartUtil.setupXYPlot(chart, new SimpleDateFormat("HH:mm:ss"));
        chart.getXYPlot().setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        if (config.isShowpercentile()) {
            text = bundle.getString("chronos.label.percentile95.arrow");
            ChartUtil.addRangeMarker(chart.getXYPlot(), text, samples.getPercentile95(config.getResponsetimedivider()));
        }
        if (config.isShowaverage()) {
            text = bundle.getString("chronos.label.average.arrow");
            ChartUtil.addRangeMarker(chart.getXYPlot(), text, samples.getAverage(config.getResponsetimedivider()));
        }
        return chart;
    }

    private TimeSeriesCollection createResponseDataset(String name, ResponsetimeSamples samples, ResourceBundle bundle, ReportConfig config) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name), class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = ResponseChartGenerator.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        samples.appendResponsetimes(series, config.getResponsetimedivider());
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        String averageLabel = bundle.getString("chronos.label.average");
        TimeSeries averageseries = MovingAverage.createMovingAverage((TimeSeries)series, (String)averageLabel, (int)config.getAverageduration(), (int)0);
        dataset.addSeries(averageseries);
        return dataset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

