/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.chart.ChartRenderer;
import org.codehaus.mojo.chronos.chart.ChartUtil;
import org.codehaus.mojo.chronos.history.HistoricSamples;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class HistoryChartGenerator {
    private ChartRenderer renderer;
    private ResourceBundle bundle;

    public HistoryChartGenerator(ChartRenderer renderer, ResourceBundle bundle) {
        this.renderer = renderer;
        this.bundle = bundle;
    }

    public final void createResponseSummaryChart(HistoricSamples samples, String dataId, double max) throws IOException {
        String label1 = this.bundle.getString("chronos.label.average.arrow");
        TimeSeries averageSeries = samples.getAverageTime(label1);
        String label2 = this.bundle.getString("chronos.label.percentile95.arrow");
        TimeSeries percentileseries = samples.getpercentile95(label2);
        XYDataset dataset = this.getResponseDataset(averageSeries, percentileseries);
        this.renderResponseChart(dataset, "history-response-summary-" + dataId, max);
    }

    public final void createThroughputChart(HistoricSamples samples, String dataId) throws IOException {
        XYPlot xyplot = this.newPlot(samples.getThroughput(dataId), "chronos.label.throughput.requests", true);
        xyplot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        xyplot.getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        String timeLabel = this.bundle.getString("chronos.label.throughput.historytime");
        DateAxis timeAxis = ChartUtil.createTimeAxis(timeLabel, new SimpleDateFormat());
        xyplot.setDomainAxis((ValueAxis)timeAxis);
        JFreeChart chart = new JFreeChart(this.bundle.getString("chronos.label.throughput"), (Plot)xyplot);
        this.renderer.renderChart("history-throughput-" + dataId, chart);
    }

    public final void createGcChart(HistoricSamples samples, String dataId) throws IOException {
        XYPlot xyplot1 = this.newPlot(samples.getGcRatio(dataId), "chronos.label.gc.ratio", true);
        xyplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        xyplot1.getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        xyplot1.getRangeAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        XYPlot xyplot2 = this.newPlot(samples.getKbCollectedPrSecond(dataId), "chronos.label.gc.kbpersec", true);
        xyplot2.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        xyplot2.getRenderer().setSeriesPaint(0, (Paint)Color.GRAY);
        xyplot2.getRangeAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        String timeLabel = this.bundle.getString("chronos.label.gc.historytime");
        DateAxis timeAxis = ChartUtil.createTimeAxis(timeLabel, new SimpleDateFormat());
        CombinedDomainXYPlot combinedPlot = ChartUtil.createCombinedPlot(timeAxis, xyplot1, xyplot2);
        JFreeChart chart = new JFreeChart(this.bundle.getString("chronos.label.gc"), (Plot)combinedPlot);
        this.renderer.renderChart("history-gc-" + dataId, chart);
    }

    private XYPlot newPlot(TimeSeries timeSeries, String label, boolean forceIncludeZero) {
        return ChartUtil.newPlot(timeSeries, this.bundle.getString(label), forceIncludeZero);
    }

    public final void createResponseDetailsChart(HistoricSamples samples, String dataId) throws IOException {
        double maxgraphupperbound = 0.0;
        String[] groupNames = samples.getGroupNames();
        for (int i = 0; i < groupNames.length; ++i) {
            String label1 = this.bundle.getString("chronos.label.average.arrow");
            TimeSeries averageSeries = samples.getAverageTime(label1, groupNames[i]);
            String label2 = this.bundle.getString("chronos.label.percentile95.arrow");
            TimeSeries percentileseries = samples.getPercentile95(label2, groupNames[i]);
            XYDataset dataset = this.getResponseDataset(averageSeries, percentileseries);
            this.renderResponseChart(dataset, "history-response-" + i + "-" + dataId, maxgraphupperbound);
        }
    }

    private void renderResponseChart(XYDataset dataset, String name, double max) throws IOException {
        String title = this.bundle.getString("chronos.label.responsetimes");
        String xLabel = this.bundle.getString("chronos.label.responsetimes.historytime");
        String yLabel = this.bundle.getString("chronos.label.responsetimes.responsetime");
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        if (max > 0.0) {
            ChartUtil.setUpperBound(chart, max);
        }
        ChartUtil.setupXYPlot(chart, new SimpleDateFormat());
        this.renderer.renderChart(name, chart);
    }

    private XYDataset getResponseDataset(TimeSeries averageSeries, TimeSeries percentileseries) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(averageSeries);
        dataset.addSeries(percentileseries);
        return dataset;
    }
}

