/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.chart.ChartUtil;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramChartGenerator
extends ChartUtil {
    protected JFreeChart createHistogramChart(ResponsetimeSamples samples, String label, ResourceBundle bundle, ReportConfig config) {
        double value;
        HistogramDataset histogramdataset = new HistogramDataset();
        double[] sampleArray = samples.extractResponsetimes(config.getResponsetimedivider());
        histogramdataset.addSeries((Comparable)((Object)label), sampleArray, 100);
        HistogramDataset dataset = histogramdataset;
        JFreeChart chart = ChartFactory.createHistogram((String)bundle.getString("chronos.label.histogram"), (String)bundle.getString("chronos.label.histogram.x"), (String)bundle.getString("chronos.label.histogram.y"), (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setForegroundAlpha(0.85f);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setDrawBarOutline(false);
        if (config.isShowpercentile()) {
            String label1 = bundle.getString("chronos.label.percentile95.arrow");
            value = samples.getPercentile95(config.getResponsetimedivider());
            ChartUtil.addDomainMarker(xyplot, label1, value);
        }
        if (config.isShowaverage()) {
            String label2 = bundle.getString("chronos.label.average.arrow");
            value = samples.getAverage(config.getResponsetimedivider());
            ChartUtil.addDomainMarker(xyplot, label2, value);
        }
        return chart;
    }
}

