/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.chart.ChartRenderer;
import org.codehaus.mojo.chronos.chart.ChartSource;
import org.codehaus.mojo.chronos.chart.ChronosReportPlugin;
import org.jfree.chart.JFreeChart;

public class GraphGenerator {
    private List summaryChartSources = new ArrayList();
    private Map detailsChartSources = new LinkedHashMap();

    public GraphGenerator(List plugins) {
        Iterator iterator = plugins.iterator();
        while (iterator.hasNext()) {
            ChronosReportPlugin plugin = (ChronosReportPlugin)iterator.next();
            ChartSource summarySource = plugin.getSummaryChartSource();
            if (summarySource != null) {
                this.summaryChartSources.add(summarySource);
            }
            Map detailsSources = plugin.getDetailChartSources();
            Iterator iterator2 = detailsSources.keySet().iterator();
            while (iterator2.hasNext()) {
                String testName = (String)iterator2.next();
                ArrayList existing = (ArrayList)this.detailsChartSources.get(testName);
                if (existing == null) {
                    existing = new ArrayList();
                    this.detailsChartSources.put(testName, existing);
                }
                existing.add(detailsSources.get(testName));
            }
        }
    }

    public void generateGraphs(ChartRenderer renderer, ResourceBundle bundle, ReportConfig config) throws IOException {
        Iterator<Object> iterator = this.getSummaryChartSources().iterator();
        while (iterator.hasNext()) {
            ChartSource chartSource = (ChartSource)iterator.next();
            if (!chartSource.isEnabled(bundle, config)) continue;
            JFreeChart chart = chartSource.getChart(bundle, config);
            String fileName = chartSource.getFileName(bundle, config);
            renderer.renderChart(fileName, chart);
        }
        iterator = this.detailsChartSources.values().iterator();
        while (iterator.hasNext()) {
            List sources = (List)iterator.next();
            Iterator iterator2 = sources.iterator();
            while (iterator2.hasNext()) {
                ChartSource source = (ChartSource)iterator2.next();
                if (!source.isEnabled(bundle, config)) continue;
                JFreeChart chart = source.getChart(bundle, config);
                String fileName = source.getFileName(bundle, config);
                renderer.renderChart(fileName, chart);
            }
        }
    }

    public List getSummaryChartSources() {
        return this.summaryChartSources;
    }

    public List getDetailsChartSources(String testName) {
        return (List)this.detailsChartSources.get(testName);
    }
}

