/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.mojo.chronos.chart.ChartSource;
import org.codehaus.mojo.chronos.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.chart.DetailsResponsetimeChartSource;
import org.codehaus.mojo.chronos.chart.SummaryResponsetimeChartSource;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;

public class ChronosResponsetimePlugin
implements ChronosReportPlugin {
    private ResponsetimeSamples samples;

    public ChronosResponsetimePlugin(ResponsetimeSamples samples) {
        this.samples = samples;
    }

    public ChartSource getSummaryChartSource() {
        return new SummaryResponsetimeChartSource(this.samples);
    }

    public Map getDetailChartSources() {
        LinkedHashMap<String, DetailsResponsetimeChartSource> testname2ChartSource = new LinkedHashMap<String, DetailsResponsetimeChartSource>();
        if (!(this.samples instanceof GroupedResponsetimeSamples)) {
            return testname2ChartSource;
        }
        GroupedResponsetimeSamples groupedSamples = (GroupedResponsetimeSamples)this.samples;
        Iterator it2 = groupedSamples.getSampleGroups().iterator();
        while (it2.hasNext()) {
            ResponsetimeSampleGroup sampleGroup = (ResponsetimeSampleGroup)it2.next();
            DetailsResponsetimeChartSource source = new DetailsResponsetimeChartSource(sampleGroup);
            testname2ChartSource.put(sampleGroup.getName(), source);
        }
        return testname2ChartSource;
    }
}

