/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.mojo.chronos.chart.ChartSource;
import org.codehaus.mojo.chronos.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.chart.DetailsHistogramChartSource;
import org.codehaus.mojo.chronos.chart.SummaryHistogramChartSource;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;

public class ChronosHistogramPlugin
implements ChronosReportPlugin {
    private ResponsetimeSamples samples;

    public ChronosHistogramPlugin(ResponsetimeSamples samples) {
        this.samples = samples;
    }

    public ChartSource getSummaryChartSource() {
        return new SummaryHistogramChartSource(this.samples);
    }

    public Map getDetailChartSources() {
        LinkedHashMap<String, DetailsHistogramChartSource> testname2ChartSource = new LinkedHashMap<String, DetailsHistogramChartSource>();
        if (!(this.samples instanceof GroupedResponsetimeSamples)) {
            return testname2ChartSource;
        }
        GroupedResponsetimeSamples groupedSamples = (GroupedResponsetimeSamples)this.samples;
        Iterator it2 = groupedSamples.getSampleGroups().iterator();
        while (it2.hasNext()) {
            ResponsetimeSampleGroup sampleGroup = (ResponsetimeSampleGroup)it2.next();
            testname2ChartSource.put(sampleGroup.getName(), new DetailsHistogramChartSource(sampleGroup));
        }
        return testname2ChartSource;
    }
}

