/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.chronos.chart.ChronosGCPlugin;
import org.codehaus.mojo.chronos.chart.ChronosHistogramPlugin;
import org.codehaus.mojo.chronos.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.chart.ChronosResponsetimePlugin;
import org.codehaus.mojo.chronos.chart.ChronosThroughputPlugin;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class ChartUtil {
    public static List createDefaultPlugins(ResponsetimeSamples samples, GCSamples gcSamples) {
        ArrayList<ChronosReportPlugin> plugins = new ArrayList<ChronosReportPlugin>();
        plugins.add(new ChronosResponsetimePlugin(samples));
        plugins.add(new ChronosHistogramPlugin(samples));
        plugins.add(new ChronosThroughputPlugin(samples));
        plugins.add(new ChronosGCPlugin(gcSamples));
        return plugins;
    }

    public static void addDomainMarker(XYPlot xyplot, String label, double value) {
        xyplot.addDomainMarker((Marker)ChartUtil.addValueMarker(label, value, true));
    }

    public static void addRangeMarker(XYPlot xyplot, String label, double value) {
        xyplot.addRangeMarker((Marker)ChartUtil.addValueMarker(label, value, false));
    }

    private static ValueMarker addValueMarker(String text, double x, boolean domain) {
        ValueMarker marker = new ValueMarker(x);
        marker.setPaint((Paint)Color.GRAY);
        marker.setLabel(text);
        if (domain) {
            marker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        } else {
            marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            marker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        }
        return marker;
    }

    public static XYPlot setupXYPlot(JFreeChart chart, DateFormat dateFormat) {
        XYPlot plot = chart.getXYPlot();
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(dateFormat);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return plot;
    }

    public static XYPlot setUpperBound(JFreeChart chart, double max) {
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setUpperBound(max);
        return plot;
    }

    static CombinedDomainXYPlot createCombinedPlot(DateAxis timeAxis, XYPlot xyplot1, XYPlot xyplot2) {
        CombinedDomainXYPlot combineddomainxyplot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        combineddomainxyplot.setGap(10.0);
        combineddomainxyplot.add(xyplot1, 2);
        combineddomainxyplot.add(xyplot2, 1);
        combineddomainxyplot.setOrientation(PlotOrientation.VERTICAL);
        return combineddomainxyplot;
    }

    public static XYPlot newPlot(TimeSeries timeSeries, String label, boolean forceIncludeZero) {
        XYDataset dataset = ChartUtil.asDataset(timeSeries);
        return ChartUtil.newPlot(dataset, label, forceIncludeZero);
    }

    static XYPlot newPlot(XYDataset dataset, String label, boolean forceIncludeZero) {
        StandardXYItemRenderer standardxyitemrenderer = new StandardXYItemRenderer();
        NumberAxis numberaxis = new NumberAxis(label);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberaxis.setAutoRangeIncludesZero(forceIncludeZero);
        return new XYPlot(dataset, null, (ValueAxis)numberaxis, (XYItemRenderer)standardxyitemrenderer);
    }

    private static XYDataset asDataset(TimeSeries series) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    static DateAxis createTimeAxis(String label, SimpleDateFormat dateFormat) {
        DateAxis timeAxis = new DateAxis(label);
        timeAxis.setDateFormatOverride((DateFormat)dateFormat);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        return timeAxis;
    }
}

