/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.jfree.data.time.Millisecond;

public class Utils {
    static /* synthetic */ Class class$org$codehaus$mojo$chronos$Utils;

    public static Millisecond createMS(long millisecond) {
        return new Millisecond((int)millisecond, 0, 0, 0, 1, 1, 1970);
    }

    public static final ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("chronos", locale, (class$org$codehaus$mojo$chronos$Utils == null ? (class$org$codehaus$mojo$chronos$Utils = Utils.class$("org.codehaus.mojo.chronos.Utils")) : class$org$codehaus$mojo$chronos$Utils).getClassLoader());
    }

    public static File getChronosDir(File baseDir) {
        File target = new File(baseDir, "target");
        File chronos = new File(target, "chronos");
        Utils.ensureParentDir(chronos);
        if (!chronos.exists()) {
            chronos.mkdir();
        }
        return chronos;
    }

    public static File getGcSamplesSer(File baseDir, String id) {
        File chronosDir = Utils.getChronosDir(baseDir);
        return new File(chronosDir, "gc-" + id + ".ser");
    }

    public static File getPerformanceSamplesSer(File baseDir, String id) {
        File chronosDir = Utils.getChronosDir(baseDir);
        return new File(chronosDir, "perf-" + id + ".ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Serializable samples, File outputFile) throws IOException {
        Utils.ensureParentDir(outputFile);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
        try {
            out.writeObject(samples);
        }
        finally {
            out.close();
        }
    }

    public static Serializable readObject(File ser) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new FileInputStream(ser));
        try {
            Serializable serializable = (Serializable)input.readObject();
            return serializable;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            input.close();
        }
    }

    private static void ensureParentDir(File file) {
        if (file.getParentFile().exists()) {
            return;
        }
        Utils.ensureParentDir(file.getParentFile());
        file.getParentFile().mkdir();
    }

    public static GCSamples readGCSamples(File baseDir, String dataId) throws IOException {
        File gcSer = Utils.getGcSamplesSer(baseDir, dataId);
        if (!gcSer.exists()) {
            return null;
        }
        return (GCSamples)Utils.readObject(gcSer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

