/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.chronos.ReportConfig;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.chart.ChartRendererImpl;
import org.codehaus.mojo.chronos.chart.ChartUtil;
import org.codehaus.mojo.chronos.chart.GraphGenerator;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.codehaus.mojo.chronos.report.ReportGenerator;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;

public class ReportMojo
extends AbstractMavenReport {
    String outputDirectory;
    SiteRenderer siteRenderer;
    MavenProject project;
    String reportid;
    String dataid;
    String title;
    String description;
    int responsetimedivider = 1;
    int averageduration = 20000;
    int threadcountduration = 20000;
    boolean showsummary = true;
    boolean showsummarycharts = true;
    boolean showdetails = true;
    boolean showresponse = true;
    boolean showhistogram = true;
    boolean showthroughput = true;
    boolean showinfotable = true;
    boolean showtimeinfo = true;
    boolean showpercentile = true;
    boolean showaverage = true;
    boolean showgc = true;
    double historychartupperbound = 0.0;
    List plugins;

    public void executeReport(Locale locale) throws MavenReportException {
        String dataId = this.getDataId();
        File responsetimeSamples = Utils.getPerformanceSamplesSer(this.project.getBasedir(), dataId);
        if (!responsetimeSamples.exists()) {
            throw new MavenReportException("File " + responsetimeSamples.getAbsolutePath() + " not found");
        }
        try {
            GroupedResponsetimeSamples jmeterSamples = (GroupedResponsetimeSamples)Utils.readObject(responsetimeSamples);
            this.getLog().info((CharSequence)("  tests: " + jmeterSamples.getSampleGroups().size()));
            this.getLog().info((CharSequence)("  jmeter samples: " + jmeterSamples.size()));
            this.getLog().info((CharSequence)" generating charts...");
            GCSamples gcSamples = this.getGcSamples(dataId);
            List defaultPlugins = ChartUtil.createDefaultPlugins(jmeterSamples, gcSamples);
            this.getLog().info((CharSequence)("" + this.plugins));
            if (this.plugins != null) {
                defaultPlugins.addAll(this.plugins);
            }
            GraphGenerator graphGenerator = new GraphGenerator(defaultPlugins);
            ChartRendererImpl renderer = new ChartRendererImpl(this.getOutputDirectory());
            graphGenerator.generateGraphs(renderer, this.getBundle(locale), this.getConfig());
            ReportGenerator reportGenerator = new ReportGenerator(this.getBundle(locale), this.getConfig(), graphGenerator);
            this.getLog().info((CharSequence)" generating report...");
            reportGenerator.doGenerateReport(this.getSink(), jmeterSamples);
        }
        catch (IOException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
    }

    private String getDataId() {
        return this.dataid;
    }

    private GCSamples getGcSamples(String dataId) throws IOException {
        if (!this.showgc) {
            return null;
        }
        return Utils.readGCSamples(this.project.getBasedir(), dataId);
    }

    public String getName(Locale locale) {
        return this.getOutputName();
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("chronos.description");
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.getConfig().getId();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    ResourceBundle getBundle(Locale locale) {
        return Utils.getBundle(locale);
    }

    public boolean canGenerateReport() {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        return "java".equals(artifactHandler.getLanguage());
    }

    protected ReportConfig getConfig() {
        return new ReportConfig(){

            public String getId() {
                return ReportMojo.this.reportid != null ? ReportMojo.this.reportid : ReportMojo.this.dataid;
            }

            public String getTitle() {
                return ReportMojo.this.title;
            }

            public String getDescription() {
                return ReportMojo.this.description;
            }

            public int getAverageduration() {
                return ReportMojo.this.averageduration;
            }

            public int getResponsetimedivider() {
                return ReportMojo.this.responsetimedivider;
            }

            public long getThreadcountduration() {
                return ReportMojo.this.threadcountduration;
            }

            public double getHistoryChartUpperBound() {
                return ReportMojo.this.historychartupperbound;
            }

            public boolean isShowaverage() {
                return ReportMojo.this.showaverage;
            }

            public boolean isShowdetails() {
                return ReportMojo.this.showdetails;
            }

            public boolean isShowgc() {
                if (!ReportMojo.this.showgc) {
                    return false;
                }
                File gcSamplesSer = Utils.getGcSamplesSer(ReportMojo.this.project.getBasedir(), ReportMojo.this.getDataId());
                if (gcSamplesSer.exists()) {
                    return true;
                }
                ReportMojo.this.getLog().warn((CharSequence)("Could not find gc info from " + gcSamplesSer.getAbsolutePath()));
                return false;
            }

            public boolean isShowhistogram() {
                return ReportMojo.this.showhistogram;
            }

            public boolean isShowinfotable() {
                return ReportMojo.this.showinfotable;
            }

            public boolean isShowpercentile() {
                return ReportMojo.this.showpercentile;
            }

            public boolean isShowresponse() {
                return ReportMojo.this.showresponse;
            }

            public boolean isShowsummary() {
                return ReportMojo.this.showsummary;
            }

            public boolean isShowsummarycharts() {
                return ReportMojo.this.showsummarycharts;
            }

            public boolean isShowthroughput() {
                return ReportMojo.this.showthroughput;
            }

            public boolean isShowtimeinfo() {
                return ReportMojo.this.showtimeinfo;
            }
        };
    }
}

