/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.Utils;
import org.codehaus.mojo.chronos.gc.GCSamples;
import org.codehaus.mojo.chronos.responsetime.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.responsetime.ResponsetimeSamples;

public class CheckMojo
extends AbstractMojo {
    double gctimeratio;
    double collectedprsecond;
    double maxthroughput;
    double responsetimeaverage;
    double responsetime95;
    double responsetimemax;
    int responsetimedivider = 1;
    int averageduration = 20000;
    String dataid;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File responsetimeSamples = Utils.getPerformanceSamplesSer(this.project.getBasedir(), this.dataid);
        if (!responsetimeSamples.exists()) {
            throw new MojoExecutionException("File " + responsetimeSamples.getAbsolutePath() + " not found");
        }
        try {
            GroupedResponsetimeSamples rtSamples = (GroupedResponsetimeSamples)Utils.readObject(responsetimeSamples);
            long totalTime = rtSamples.getTotalTime();
            this.validateMaxThroughput(rtSamples);
            this.validateAverageResponsetime(rtSamples);
            this.validatePercentile95Responsetime(rtSamples);
            this.validateMaxResponsetime(rtSamples);
            GCSamples gcSamples = Utils.readGCSamples(this.project.getBasedir(), this.dataid);
            if (gcSamples != null) {
                this.validateGCTime(gcSamples, totalTime);
                this.validateCollectedPrSecond(gcSamples, totalTime);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure", (Exception)e);
        }
    }

    void validateGCTime(GCSamples gcSamples, long totalTime) throws MojoExecutionException {
        if (this.gctimeratio <= 0.0) {
            return;
        }
        double actualRatio = gcSamples.getGarbageCollectionRatio(totalTime);
        if (actualRatio > this.gctimeratio) {
            throw new MojoExecutionException("To much time spent garbagecollection. Ratio of time spent was " + actualRatio + " but acceptable level was " + this.gctimeratio);
        }
    }

    void validateCollectedPrSecond(GCSamples samples, long totalTime) throws MojoExecutionException {
        if (this.collectedprsecond <= 0.0) {
            return;
        }
        double actual = samples.getCollectedKBPerSecond(totalTime);
        if (actual > this.collectedprsecond) {
            throw new MojoExecutionException("To much stuff garbagecollected. Garbagecollected pr second was " + actual + "kb but acceptable level was " + this.collectedprsecond);
        }
    }

    void validateMaxThroughput(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.maxthroughput <= 0.0) {
            return;
        }
        double actual = samples.getMaxAverageThroughput(this.averageduration, this.responsetimedivider);
        if (actual < this.maxthroughput) {
            throw new MojoExecutionException("Throughput too low. Throughput was " + actual + " but required throughput was " + this.maxthroughput);
        }
    }

    void validateAverageResponsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.responsetimeaverage <= 0.0) {
            return;
        }
        double actual = samples.getAverage(this.responsetimedivider);
        if (actual > this.responsetimeaverage) {
            throw new MojoExecutionException("Average responsetime too high. Average was " + actual + " but acceptable was " + this.responsetimeaverage);
        }
    }

    void validatePercentile95Responsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.responsetime95 <= 0.0) {
            return;
        }
        double actual = samples.getPercentile95(this.responsetimedivider);
        if (actual > this.responsetime95) {
            throw new MojoExecutionException("95 percentile responsetime too high. Measured was " + actual + " but acceptable was " + this.responsetime95);
        }
    }

    void validateMaxResponsetime(ResponsetimeSamples samples) throws MojoExecutionException {
        if (this.responsetimemax <= 0.0) {
            return;
        }
        double actual = samples.getMax(this.responsetimedivider);
        if (actual > this.responsetimemax) {
            throw new MojoExecutionException("Max responsetime too high. Measured was " + actual + " but acceptable was " + this.responsetimemax);
        }
    }
}

