/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.util.ArrayList;
import org.apache.maven.util.EnhancedStringTokenizer;

public final class RepositoryUtils {
    public static String[] splitSCMConnection(String connection) {
        if (connection == null) {
            throw new NullPointerException("repository connection is null");
        }
        if (connection.length() < 4) {
            throw new IllegalArgumentException("repository connection is too short");
        }
        if (!connection.startsWith("scm")) {
            throw new IllegalArgumentException("repository connection must start with scm[delim]");
        }
        String delimiter = "" + connection.charAt(3);
        EnhancedStringTokenizer tok = new EnhancedStringTokenizer(connection, delimiter);
        String[] tokens = RepositoryUtils.tokenizerToArray(tok);
        if (tokens.length >= 1 && tokens[1].equals("cvs")) {
            if (tokens.length >= 2 && tokens[2].equals("local")) {
                if (tokens.length == 6) {
                    if (tokens[3].length() > 0 && !tokens[3].equals("local")) {
                        throw new IllegalArgumentException("cvs local repository connection string must specify 5 tokens, or an empty 3rd token if 6");
                    }
                } else if (tokens.length == 5) {
                    String[] newTokens = new String[]{tokens[0], tokens[1], tokens[2], "", tokens[3], tokens[4]};
                    tokens = newTokens;
                } else {
                    throw new IllegalArgumentException("cvs local repository connection string doesn't contain five tokens");
                }
            }
            if (tokens.length != 6) {
                throw new IllegalArgumentException("cvs repository connection string doesn't contain six tokens");
            }
        }
        return tokens;
    }

    public static String[] tokenizerToArray(EnhancedStringTokenizer tok) {
        ArrayList<String> l = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            l.add(tok.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }
}

