/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.clearcaselib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;

public class ClearcaseChangeLogParser
implements ChangeLogParser {
    private static final SimpleDateFormat CLEARCASE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss");
    private static final String NAME_TAG = "NAME:";
    private static final String USER_TAG = "USER:";
    private static final String DATE_TAG = "DATE:";
    private static final String COMMENT_TAG = "COMM:";
    private static final SimpleDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static final SimpleDateFormat GROUPED_ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private Map entries = new TreeMap(Collections.reverseOrder());
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private int status = 1;
    private ChangeLogEntry currentLogEntry = null;
    private ChangeLogFile currentFile = null;

    public void init(ChangeLog changeLog) {
    }

    public void cleanup() {
    }

    public Collection parse(InputStream anInputStream) throws IOException {
        BufferedReader stream = new BufferedReader(new InputStreamReader(anInputStream));
        String line = null;
        block5: while ((line = stream.readLine()) != null) {
            switch (this.getStatus()) {
                case 1: {
                    this.processGetFile(line);
                    continue block5;
                }
                case 2: {
                    this.processGetDate(line);
                    continue block5;
                }
                case 3: {
                    this.processGetCommentAndUser(line);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown state: " + this.status);
        }
        return this.entries.values();
    }

    private void addEntry(ChangeLogEntry entry, ChangeLogFile file) {
        if (entry.getAuthor() == null) {
            return;
        }
        if (entry.getComment().indexOf("checkin ") == -1) {
            return;
        }
        String key = ENTRY_KEY_TIMESTAMP_FORMAT.format(entry.getDate()) + entry.getAuthor() + entry.getComment();
        file.setRevision("");
        if (!this.entries.containsKey(key)) {
            entry.addFile(file);
            this.entries.put(key, entry);
        } else {
            ChangeLogEntry existingEntry = (ChangeLogEntry)this.entries.get(key);
            existingEntry.addFile(file);
        }
    }

    private void processGetFile(String line) {
        if (line.startsWith(NAME_TAG)) {
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(line.substring(NAME_TAG.length(), line.length())));
            this.setStatus(2);
        }
    }

    private void processGetDate(String line) {
        if (line.startsWith(DATE_TAG)) {
            try {
                this.getCurrentLogEntry().setDate(CLEARCASE_TIMESTAMP_FORMAT.parse(line.substring(DATE_TAG.length())));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.setStatus(3);
        }
    }

    private void processGetCommentAndUser(String line) {
        if (line.startsWith(COMMENT_TAG)) {
            String comm = line.substring(COMMENT_TAG.length());
            this.getCurrentLogEntry().setComment(this.getCurrentLogEntry().getComment() + comm + "\n");
        } else if (line.startsWith(USER_TAG)) {
            this.getCurrentLogEntry().setAuthor(line.substring(USER_TAG.length()).trim());
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setStatus(1);
        } else {
            this.getCurrentLogEntry().setComment(this.getCurrentLogEntry().getComment() + line + "\n");
        }
    }

    private ChangeLogFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(ChangeLogFile currentFile) {
        this.currentFile = currentFile;
    }

    private ChangeLogEntry getCurrentLogEntry() {
        return this.currentLogEntry;
    }

    private void setCurrentLogEntry(ChangeLogEntry currentLogEntry) {
        this.currentLogEntry = currentLogEntry;
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    public void setDateFormatInFile(String dateFormat) {
    }
}

