/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogReport;
import org.apache.maven.changelog.ChangeLogSet;
import org.apache.maven.model.Developer;
import org.codehaus.doxia.sink.Sink;

public class DeveloperActivityReport
extends ChangeLogReport {
    private List developers;
    private HashMap commits;
    private HashMap files;

    public String getDescription(Locale locale) {
        return "Generated developer activity report from SCM";
    }

    public String getName(Locale locale) {
        return "dev-activity";
    }

    public String getOutputName() {
        return "dev-activity";
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.dev-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.dev-activity.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(Collection changeSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.dev-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.dev-activity.mainTitle"));
        sink.sectionTitle1_();
        Iterator i = changeSets.iterator();
        while (i.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)i.next();
            this.doChangedSets(set, bundle, sink);
        }
        sink.section1_();
        sink.body_();
        sink.table_();
    }

    private void doChangedSets(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        sink.sectionTitle2();
        if (set.getStart() == null) {
            sink.text(bundle.getString("report.SetRangeUnknown"));
        } else if (set.getEnd() == null) {
            sink.text(bundle.getString("report.SetRangeSince"));
        } else {
            sink.text(" " + set.getStart() + " " + bundle.getString("report.To") + " " + set.getEnd());
            sink.sectionTitle2_();
        }
        this.doSummary(set, bundle, sink);
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.dev-activity.developer"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.TotalCommits"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.dev-activity.filesChanged"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.doDeveloperRows(set, sink);
        sink.table_();
        sink.section2_();
    }

    private void doSummary(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.dev-activity.range"));
        sink.text(": " + set.getStart() + " " + bundle.getString("report.To") + " " + set.getEnd());
        sink.text(", " + bundle.getString("report.TotalCommits"));
        sink.text(":" + set.getEntries().size());
        sink.text(", " + bundle.getString("report.dev-activity.filesChanged"));
        sink.text(":" + this.countFilesChanged(set.getEntries()));
        sink.paragraph_();
    }

    private long getCommits(Collection sets) {
        long commits = 0L;
        Iterator i = sets.iterator();
        while (i.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)i.next();
            commits += (long)set.getEntries().size();
        }
        return commits;
    }

    private long getFilesChanged(Collection sets) {
        long count = 0L;
        Iterator i = sets.iterator();
        while (i.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)i.next();
            count += this.countFilesChanged(set.getEntries());
        }
        return count;
    }

    private void doDeveloperRows(ChangeLogSet set, Sink sink) {
        this.getDeveloperDetails(set);
        Iterator i = this.developers.iterator();
        while (i.hasNext()) {
            Developer developer = (Developer)i.next();
            String name = developer.getName();
            if (!this.commits.containsKey(name)) continue;
            LinkedList devCommits = (LinkedList)this.commits.get(name);
            HashMap devFiles = (HashMap)this.files.get(name);
            sink.tableRow();
            sink.tableCell();
            sink.link("team-list.html#" + developer.getId());
            sink.text(name);
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + devCommits.size());
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + devFiles.size());
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    private void getDeveloperDetails(ChangeLogSet set) {
        this.commits = new HashMap();
        this.files = new HashMap();
        this.countDevCommits(set.getEntries());
        this.countDevFiles(set.getEntries());
    }

    private void countDevCommits(Collection entries) {
        Iterator i2 = entries.iterator();
        while (i2.hasNext()) {
            ChangeLogEntry entry = (ChangeLogEntry)i2.next();
            String developer = entry.getAuthor();
            LinkedList list = this.commits.containsKey(developer) ? (LinkedList)this.commits.get(developer) : new LinkedList();
            list.add(entry);
            this.commits.put(developer, list);
        }
    }

    private void countDevFiles(Collection entries) {
        Iterator i2 = entries.iterator();
        while (i2.hasNext()) {
            ChangeLogEntry entry = (ChangeLogEntry)i2.next();
            String developer = entry.getAuthor();
            HashMap filesMap = this.files.containsKey(developer) ? (HashMap)this.files.get(developer) : new HashMap();
            Iterator i3 = ((AbstractList)entry.getFiles()).iterator();
            while (i3.hasNext()) {
                ChangeLogFile file = (ChangeLogFile)i3.next();
                filesMap.put(file.getName(), file);
            }
            this.files.put(developer, filesMap);
        }
    }
}

