/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractScmMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.scm.connection}", alias="readUrlScm", readonly=true)
    protected String scmConnectionUrl;
    @Parameter(defaultValue="${project.scm.developerConnection}", alias="urlScm", readonly=true)
    protected String scmDeveloperConnectionUrl;
    @Parameter(defaultValue="${project.scm.tag}", readonly=true)
    protected String scmTag;
    @Parameter(property="username")
    protected String username;
    @Parameter(property="password")
    protected String password;
    @Parameter(property="maven.buildNumber.scmDirectory", defaultValue="${basedir}")
    protected File scmDirectory;
    @Parameter(property="maven.buildNumber.shortRevisionLength", defaultValue="0")
    protected int shortRevisionLength = 0;
    @Parameter(property="maven.buildNumber.revisionOnScmFailure")
    protected String revisionOnScmFailure;
    @Parameter(property="maven.buildNumber.useLastCommittedRevision", defaultValue="false")
    private boolean useLastCommittedRevision;
    @Parameter(property="maven.buildNumber.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected ScmManager scmManager;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                this.setPasswordIfNotEmpty((ScmProviderRepository)repo, this.decrypt(server.getPassword(), host));
                this.setUserIfNotEmpty((ScmProviderRepository)repo, server.getUsername());
            }
        }
    }

    private String decrypt(String str, String server) {
        try {
            return this.securityDispatcher.decrypt(str);
        }
        catch (SecDispatcherException e) {
            this.getLog().warn((CharSequence)("Failed to decrypt password/passphrase for server " + server + ", using auth token as is"));
            return str;
        }
    }

    protected ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository = this.scmManager.makeScmRepository(!StringUtils.isBlank((String)this.scmConnectionUrl) ? this.scmConnectionUrl : this.scmDeveloperConnectionUrl);
        ScmProviderRepository scmRepo = repository.getProviderRepository();
        if (scmRepo instanceof ScmProviderRepositoryWithHost) {
            this.loadInfosFromSettings((ScmProviderRepositoryWithHost)scmRepo);
        }
        this.setPasswordIfNotEmpty(scmRepo, this.password);
        this.setUserIfNotEmpty(scmRepo, this.username);
        return repository;
    }

    private void setPasswordIfNotEmpty(ScmProviderRepository repository, String password) {
        if (!StringUtils.isEmpty((String)password)) {
            repository.setPassword(password);
        }
    }

    private void setUserIfNotEmpty(ScmProviderRepository repository, String user) {
        if (!StringUtils.isEmpty((String)user)) {
            repository.setUser(user);
        }
    }

    protected void checkResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)result.getProviderMessage());
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)result.getCommandOutput());
            throw new ScmException("Error!");
        }
    }

    protected InfoScmResult info(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        CommandParameters commandParameters = new CommandParameters();
        if ("git".equals(this.scmManager.getProviderByRepository(repository).getScmType()) && this.shortRevisionLength > 0) {
            this.getLog().info((CharSequence)("ShortRevision tag detected. The value is '" + this.shortRevisionLength + "'."));
            if (this.shortRevisionLength >= 0 && this.shortRevisionLength < 4) {
                this.getLog().warn((CharSequence)"shortRevision parameter less then 4. ShortRevisionLength is relaying on 'git rev-parese --short=LENGTH' command, accordingly to Git rev-parse specification the LENGTH value is miminum 4. ");
            }
            commandParameters.setInt(CommandParameter.SCM_SHORT_REVISION_LENGTH, this.shortRevisionLength);
        }
        if (!StringUtils.isBlank((String)this.scmTag) && !"HEAD".equals(this.scmTag)) {
            commandParameters.setScmVersion(CommandParameter.SCM_VERSION, (ScmVersion)new ScmTag(this.scmTag));
        }
        return this.scmManager.getProviderByRepository(repository).info(repository.getProviderRepository(), fileSet, commandParameters);
    }

    protected String getScmRevision() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        InfoScmResult scmResult = this.info(repository, new ScmFileSet(this.scmDirectory));
        if (scmResult == null || scmResult.getInfoItems().isEmpty()) {
            return !StringUtils.isEmpty((String)this.revisionOnScmFailure) ? this.revisionOnScmFailure : null;
        }
        this.checkResult((ScmResult)scmResult);
        InfoItem info = (InfoItem)scmResult.getInfoItems().get(0);
        if (this.useLastCommittedRevision) {
            return info.getLastChangedRevision();
        }
        return info.getRevision();
    }
}

