/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

public class CreateTimestampMojo
extends AbstractMojo {
    private MavenProject project;
    private List reactorProjects;
    private String timestampPropertyName;
    private String timestampFormat;

    public void execute() {
        String timestampString = this.project.getProperties().getProperty(this.timestampPropertyName);
        if (timestampString != null) {
            this.getLog().debug((CharSequence)"Using previously created timestamp.");
            return;
        }
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        if (this.timestampFormat == null || this.timestampFormat.equals("")) {
            timestampString = String.valueOf(now.getTime());
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampFormat);
            timestampString = dateFormat.format(now);
        }
        this.getLog().debug((CharSequence)("Storing timestamp property: " + this.timestampPropertyName + " " + timestampString));
        for (MavenProject nextProj : this.reactorProjects) {
            nextProj.getProperties().setProperty(this.timestampPropertyName, timestampString);
        }
    }
}

