/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class OsgiArtifactVersion
implements ArtifactVersion {
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;

    public OsgiArtifactVersion(String version) {
        this.parseVersion(version);
    }

    public int compareTo(Object o) {
        OsgiArtifactVersion otherVersion = (OsgiArtifactVersion)o;
        int result = this.compareIntegers(this.majorVersion, otherVersion.majorVersion);
        if (result == 0) {
            result = this.compareIntegers(this.minorVersion, otherVersion.minorVersion);
        }
        if (result == 0) {
            result = this.compareIntegers(this.incrementalVersion, otherVersion.incrementalVersion);
        }
        if (result == 0) {
            if (this.buildNumber != null || otherVersion.buildNumber != null) {
                result = this.compareIntegers(this.buildNumber, otherVersion.buildNumber);
            } else if (this.qualifier != null) {
                result = otherVersion.qualifier != null ? (this.qualifier.length() > otherVersion.qualifier.length() && this.qualifier.startsWith(otherVersion.qualifier) ? -1 : (this.qualifier.length() < otherVersion.qualifier.length() && otherVersion.qualifier.startsWith(this.qualifier) ? 1 : this.qualifier.compareTo(otherVersion.qualifier))) : -1;
            } else if (otherVersion.qualifier != null) {
                result = 1;
            }
        }
        return result;
    }

    private int compareIntegers(Integer i1, Integer i2) {
        if (i1 == null ? i2 == null : i1.equals(i2)) {
            return 0;
        }
        if (i1 == null) {
            return -1;
        }
        if (i2 == null) {
            return 1;
        }
        return i1 - i2;
    }

    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void parseVersion(String version) {
        boolean fallback = false;
        if (version.indexOf(46) == -1) {
            fallback = true;
        } else {
            StringTokenizer tok = new StringTokenizer(version, ".");
            try {
                this.majorVersion = OsgiArtifactVersion.getNextIntegerToken(tok);
                if (tok.hasMoreTokens()) {
                    this.minorVersion = OsgiArtifactVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    this.incrementalVersion = OsgiArtifactVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    this.qualifier = tok.nextToken();
                }
            }
            catch (NumberFormatException e) {
                fallback = true;
            }
        }
        if (fallback) {
            this.qualifier = version;
            this.majorVersion = null;
            this.minorVersion = null;
            this.incrementalVersion = null;
        }
    }

    private static Integer getNextIntegerToken(StringTokenizer tok) {
        String s = tok.nextToken();
        if (s.length() > 1 && s.startsWith("0")) {
            throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
        }
        return Integer.valueOf(s);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.majorVersion != null) {
            buf.append(this.majorVersion);
        }
        if (this.minorVersion != null) {
            buf.append(".");
            buf.append(this.minorVersion);
        }
        if (this.incrementalVersion != null) {
            buf.append(".");
            buf.append(this.incrementalVersion);
        }
        if (this.qualifier != null) {
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(this.qualifier);
        }
        return buf.toString();
    }
}

