/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.HashSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.buildhelper.Artifact;

public class AttachArtifact
extends AbstractMojo {
    private Artifact[] artifacts;
    private MavenProject project;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateArtifacts();
        for (int i = 0; i < this.artifacts.length; ++i) {
            this.projectHelper.attachArtifact(this.project, this.artifacts[i].getType(), this.artifacts[i].getClassifier(), this.artifacts[i].getFile());
        }
    }

    private void validateArtifacts() throws MojoFailureException {
        HashSet<String> extensionClassifiers = new HashSet<String>();
        for (int i = 0; i < this.artifacts.length; ++i) {
            Artifact artifact = this.artifacts[i];
            String extensionClassifier = artifact.getType() + ":" + artifact.getClassifier();
            if (extensionClassifiers.add(extensionClassifier)) continue;
            throw new MojoFailureException("The artifact with same type and classifier: " + extensionClassifier + " is used more than once.");
        }
    }
}

