/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.aspectj.tools.ajdoc.Main;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.aspectj.AjcHelper;
import org.codehaus.plexus.util.StringUtils;

public class AjcReportMojo
extends AbstractMavenReport {
    protected String aspectDirectory = "src/main/aspect";
    protected String testAspectDirectory = "src/test/aspect";
    protected MavenProject project;
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected String ajdtBuildDefFile;
    private SiteRenderer siteRenderer;
    protected boolean packageScope;
    protected boolean protectedScope;
    protected boolean privateScope;
    protected boolean publicScope;
    protected String overview;
    protected String doctitle;
    protected boolean verbose;
    protected String complianceLevel;
    private List ajcOptions = new ArrayList();
    private List pluginArtifacts;

    protected void executeReport(Locale locale) throws MavenReportException {
        Set includes;
        this.getLog().info((CharSequence)"Starting generating ajdoc");
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.project.getCompileSourceRoots().add(this.basedir.getAbsolutePath() + "/" + this.aspectDirectory);
        this.project.getTestCompileSourceRoots().add(this.basedir.getAbsolutePath() + "/" + this.testAspectDirectory);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-classpath");
        arguments.add(AjcHelper.createClassPath(this.project, this.pluginArtifacts, this.getOutputDirectories()));
        arguments.addAll(this.ajcOptions);
        try {
            includes = null != this.ajdtBuildDefFile ? AjcHelper.getBuildFilesForAjdtFile(this.ajdtBuildDefFile, this.basedir) : AjcHelper.getBuildFilesForSourceDirs(this.getSourceDirectories(), this.includes, this.excludes);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("AspectJ Report failed", (Exception)((Object)e));
        }
        arguments.add("-d");
        arguments.add(StringUtils.replace((String)this.getOutputDirectory(), (String)"//", (String)"/"));
        arguments.addAll(includes);
        if (this.getLog().isDebugEnabled()) {
            String command = "Running : ajdoc ";
            Iterator iter = arguments.iterator();
            while (iter.hasNext()) {
                command = command + iter.next() + " ";
            }
            this.getLog().debug((CharSequence)command);
        }
        Main.main((String[])arguments.toArray(new String[0]));
    }

    protected List getSourceDirectories() {
        ArrayList sourceDirectories = new ArrayList();
        sourceDirectories.addAll(this.project.getCompileSourceRoots());
        sourceDirectories.addAll(this.project.getTestCompileSourceRoots());
        return sourceDirectories;
    }

    protected String getOutputDirectory() {
        return this.project.getBuild().getDirectory() + "/site/aspectj-report";
    }

    protected List getOutputDirectories() {
        return Arrays.asList(this.project.getBuild().getOutputDirectory(), this.project.getBuild().getTestOutputDirectory());
    }

    public String getOutputName() {
        return "aspectj-report/index";
    }

    public String getName(Locale locale) {
        return "aspectJ";
    }

    public String getDescription(Locale locale) {
        return " Similar to javadoc, Maven AspectJ Report renders HTML documentation for pointcuts, advice, and inter-type declarations, as well as the Java constructs that Javadoc renders. Maven AspectJ Report also links advice from members affected by the advice and the inter-type declaration for members declared from aspects. The aspect will be fully documented, as will your target classes, including links to any advice or declarations that affect the class. That means, for example, that you can see everything affecting a method when reading the documentation for the method.";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        return "java".equals(artifactHandler.getLanguage());
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void setOverview(String overview) {
        this.ajcOptions.add("-overview");
        this.ajcOptions.add(overview);
    }

    public void setDoctitle(String doctitle) {
        this.ajcOptions.add("-doctitle");
        this.ajcOptions.add(doctitle);
    }

    public void setPackageScope(boolean packageScope) {
        if (packageScope) {
            this.ajcOptions.add("-package");
        }
    }

    public void setPrivateScope(boolean privateScope) {
        if (privateScope) {
            this.ajcOptions.add("-private");
        }
    }

    public void setProtectedScope(boolean protectedScope) {
        if (protectedScope) {
            this.ajcOptions.add("-protected");
        }
    }

    public void setPublicScope(boolean publicScope) {
        if (publicScope) {
            this.ajcOptions.add("-public");
        }
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.ajcOptions.add("-verbose");
        }
    }

    public void setComplianceLevel(String complianceLevel) {
        if (complianceLevel.equals("1.3") || complianceLevel.equals("1.4") || complianceLevel.equals("1.5") || complianceLevel.equals("1.6")) {
            this.ajcOptions.add("-source");
            this.ajcOptions.add(complianceLevel);
        }
    }

    public void setPluginArtifacts(List pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }
}

