/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.modello.maven.AbstractModelloGeneratorMojo;

@Mojo(name="velocity", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ModelloVelocityMojo
extends AbstractModelloGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/modello")
    private File outputDirectory;
    @Parameter(defaultValue="${project.basedir}")
    private File velocityBasedir;
    @Parameter
    private List<String> templates;
    @Parameter
    private List<String> params;

    @Override
    protected String getGeneratorType() {
        return "velocity";
    }

    @Override
    protected void customizeParameters(Map<String, Object> parameters) {
        super.customizeParameters(parameters);
        Map params = this.params == null ? Collections.emptyMap() : this.params.stream().collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
        parameters.put("modello.velocity.basedir", this.velocityBasedir.getAbsolutePath());
        parameters.put("modello.velocity.templates", this.templates.stream().collect(Collectors.joining(",")));
        parameters.put("modello.velocity.parameters", params);
    }

    @Override
    protected boolean producesCompilableResult() {
        return true;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

