/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.jdk.ClassBodyEvaluator;
import org.codehaus.commons.io.Readers;
import org.codehaus.commons.nullanalysis.Nullable;

public class ScriptEvaluator
extends ClassBodyEvaluator
implements IScriptEvaluator {
    @Nullable
    protected boolean[] optionalOverrideMethod;
    @Nullable
    protected boolean[] optionalStaticMethod;
    @Nullable
    private Class<?>[] optionalReturnTypes;
    @Nullable
    private String[] optionalMethodNames;
    @Nullable
    private String[][] optionalParameterNames;
    @Nullable
    private Class<?>[][] optionalParameterTypes;
    @Nullable
    private Class<?>[][] optionalThrownExceptions;
    @Nullable
    private Method[] result;

    public ScriptEvaluator(String script) throws CompileException {
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType) throws CompileException {
        this.setReturnType(returnType);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator(@Nullable String optionalFileName, InputStream is, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, is);
    }

    public ScriptEvaluator(@Nullable String optionalFileName, Reader reader, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, reader);
    }

    public ScriptEvaluator() {
    }

    public void setOverrideMethod(boolean overrideMethod) {
        this.setOverrideMethod(new boolean[]{overrideMethod});
    }

    public void setStaticMethod(boolean staticMethod) {
        this.setStaticMethod(new boolean[]{staticMethod});
    }

    public void setReturnType(Class<?> returnType) {
        this.setReturnTypes(new Class[]{returnType});
    }

    public void setMethodName(String methodName) {
        this.setMethodNames(new String[]{methodName});
    }

    public void setParameters(String[] names, Class<?>[] types) {
        this.setParameters(new String[][]{names}, new Class[][]{types});
    }

    public void setThrownExceptions(Class<?>[] thrownExceptions) {
        this.setThrownExceptions(new Class[][]{thrownExceptions});
    }

    @Override
    public void cook(@Nullable String optionalFileName, Reader r) throws CompileException, IOException {
        this.cook(new String[]{optionalFileName}, new Reader[]{r});
    }

    @Nullable
    public Object evaluate(@Nullable Object[] arguments) throws InvocationTargetException {
        return this.evaluate(0, arguments);
    }

    public Method getMethod() {
        return this.getMethod(0);
    }

    public void setOverrideMethod(boolean[] overrideMethod) {
        this.optionalOverrideMethod = (boolean[])overrideMethod.clone();
    }

    public void setStaticMethod(boolean[] staticMethod) {
        this.optionalStaticMethod = (boolean[])staticMethod.clone();
    }

    public void setReturnTypes(Class<?>[] returnTypes) {
        for (Class<?> rt : returnTypes) {
            assert (rt != null);
        }
        this.optionalReturnTypes = (Class[])returnTypes.clone();
    }

    public void setMethodNames(String[] methodNames) {
        this.optionalMethodNames = (String[])methodNames.clone();
    }

    public void setParameters(String[][] names, Class<?>[][] types) {
        this.optionalParameterNames = (String[][])names.clone();
        this.optionalParameterTypes = (Class[][])types.clone();
    }

    public void setThrownExceptions(Class<?>[][] thrownExceptions) {
        this.optionalThrownExceptions = (Class[][])thrownExceptions.clone();
    }

    public final void cook(Reader[] readers) throws CompileException, IOException {
        this.cook(null, readers);
    }

    public void cook(@Nullable String[] optionalFileNames, Reader[] readers) throws CompileException, IOException {
        String[] imports;
        if (readers.length == 1) {
            if (!readers[0].markSupported()) {
                readers = new Reader[]{new BufferedReader(readers[0])};
            }
            imports = ClassBodyEvaluator.parseImportDeclarations(readers[0]);
        } else {
            imports = new String[]{};
        }
        this.cook(optionalFileNames, readers, imports);
    }

    public final void cook(String[] strings) throws CompileException {
        this.cook(null, strings);
    }

    public void cook(@Nullable String[] optionalFileNames, String[] strings) throws CompileException {
        Reader[] readers = new Reader[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            readers[i] = new StringReader(strings[i]);
        }
        try {
            this.cook(optionalFileNames, readers);
        }
        catch (IOException ioe) {
            throw new RuntimeException("SNO: IOException despite StringReader", ioe);
        }
    }

    protected final void cook(@Nullable String[] optionalFileNames, Reader[] readers, String[] imports) throws CompileException, IOException {
        String[] omns = this.optionalMethodNames;
        boolean[] oom = this.optionalOverrideMethod;
        boolean[] osm = this.optionalStaticMethod;
        Class<?>[] orts = this.optionalReturnTypes;
        String[][] opns = this.optionalParameterNames;
        Class<?>[][] opts = this.optionalParameterTypes;
        Class<?>[][] otes = this.optionalThrownExceptions;
        int count = readers.length;
        if (omns != null && omns.length != count) {
            throw new IllegalStateException("methodName");
        }
        if (opns != null && opns.length != count) {
            throw new IllegalStateException("parameterNames");
        }
        if (opts != null && opts.length != count) {
            throw new IllegalStateException("parameterTypes");
        }
        if (orts != null && orts.length != count) {
            throw new IllegalStateException("returnTypes");
        }
        if (oom != null && oom.length != count) {
            throw new IllegalStateException("overrideMethod");
        }
        if (osm != null && osm.length != count) {
            throw new IllegalStateException("staticMethod");
        }
        if (otes != null && otes.length != count) {
            throw new IllegalStateException("thrownExceptions");
        }
        if (omns == null) {
            omns = new String[count];
            for (int i = 0; i < count; ++i) {
                omns[i] = "eval" + i;
            }
        }
        ArrayList<Reader> classBody = new ArrayList<Reader>();
        for (int i = 0; i < count; ++i) {
            int j;
            boolean overrideMethod = oom != null && oom[i];
            boolean staticMethod = osm == null || osm[i];
            Class<?> returnType = orts != null ? orts[i] : this.getDefaultReturnType();
            String[] parameterNames = opns != null ? opns[i] : new String[]{};
            Class[] parameterTypes = opts != null ? opts[i] : new Class[]{};
            Class[] thrownExceptions = otes != null ? otes[i] : new Class[]{};
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (overrideMethod) {
                pw.print("@Override ");
            }
            pw.print("public ");
            if (staticMethod) {
                pw.print("static ");
            }
            pw.print(returnType.getCanonicalName());
            pw.print(" ");
            pw.print(omns[i]);
            pw.print("(");
            for (j = 0; j < parameterNames.length; ++j) {
                if (j > 0) {
                    pw.print(", ");
                }
                pw.print(parameterTypes[j].getName());
                pw.print(" ");
                pw.print(parameterNames[j]);
            }
            pw.print(")");
            for (j = 0; j < thrownExceptions.length; ++j) {
                pw.print(j == 0 ? " throws " : ", ");
                pw.print(thrownExceptions[j].getName());
            }
            pw.println(" {");
            pw.close();
            classBody.add(new StringReader(sw.toString()));
            classBody.add(this.newFileName(optionalFileNames != null && optionalFileNames[i] != null ? optionalFileNames[i] : (i == 0 ? null : "[" + i + "]"), readers[i]));
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            pw.println("}");
            pw.close();
            classBody.add(new StringReader(sw.toString()));
        }
        super.cook(optionalFileNames == null ? null : optionalFileNames[0], imports, Readers.concat(classBody));
        Class<?> c = this.getClazz();
        this.result = new Method[count];
        Method[] methods = this.result;
        if (count <= 10) {
            for (int i = 0; i < count; ++i) {
                try {
                    methods[i] = c.getDeclaredMethod(omns[i], opts == null ? new Class[]{} : opts[i]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException("SNO: Loaded class does not declare method \"" + omns[i] + "\"", ex);
                }
            }
        } else {
            Method[] ma = c.getDeclaredMethods();
            class MethodWrapper {
                private final String name;
                private final Class<?>[] parameterTypes;

                MethodWrapper(String name, Class<?>[] parameterTypes) {
                    this.name = name;
                    this.parameterTypes = parameterTypes;
                }

                public boolean equals(@Nullable Object o) {
                    if (!(o instanceof MethodWrapper)) {
                        return false;
                    }
                    MethodWrapper that = (MethodWrapper)o;
                    return this.name.equals(that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
                }

                public int hashCode() {
                    return this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
                }
            }
            HashMap<MethodWrapper, Method> dms = new HashMap<MethodWrapper, Method>(2 * count);
            for (Method m : ma) {
                dms.put(new MethodWrapper(m.getName(), m.getParameterTypes()), m);
            }
            for (int i = 0; i < count; ++i) {
                Method m = (Method)dms.get(new MethodWrapper(omns[i], opts == null ? new Class[]{} : opts[i]));
                if (m == null) {
                    throw new RuntimeException("SNO: Loaded class does not declare method \"" + omns[i] + "\"");
                }
                methods[i] = m;
            }
        }
    }

    protected Class<?> getDefaultReturnType() {
        return Void.TYPE;
    }

    protected final Class<?> getReturnType(int i) {
        if (this.optionalReturnTypes != null) {
            Class<?> rt = this.optionalReturnTypes[i];
            assert (rt != null);
            return rt;
        }
        return this.getDefaultReturnType();
    }

    public <T> Object createFastEvaluator(String script, Class<T> interfaceToImplement, String[] parameterNames) throws CompileException {
        try {
            return this.createFastEvaluator(new StringReader(script), interfaceToImplement, parameterNames);
        }
        catch (IOException ioe) {
            throw new RuntimeException("SNO: IOException despite StringReader", ioe);
        }
    }

    @Override
    public final Object createInstance(Reader reader) {
        throw new UnsupportedOperationException("createInstance");
    }

    public <T> Object createFastEvaluator(Reader r, Class<T> interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        if (!interfaceToImplement.isInterface()) {
            throw new RuntimeException("\"" + interfaceToImplement + "\" is not an interface");
        }
        this.setImplementedInterfaces(new Class[]{interfaceToImplement});
        this.setStaticMethod(false);
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new RuntimeException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        if (this instanceof IExpressionEvaluator) {
            ((IExpressionEvaluator)this).setExpressionType(methodToImplement.getReturnType());
        } else {
            this.setReturnType(methodToImplement.getReturnType());
        }
        this.setMethodName(methodToImplement.getName());
        this.setParameters(parameterNames, methodToImplement.getParameterTypes());
        this.setThrownExceptions(methodToImplement.getExceptionTypes());
        this.cook(r);
        Class<?> c = this.getMethod().getDeclaringClass();
        try {
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("SNO - Declared class is always non-abstract", e);
        }
        catch (Exception e) {
            throw new CompileException("Instantiating \"" + c.getName() + "\"", null, (Throwable)e);
        }
    }

    @Nullable
    public Object evaluate(int idx, @Nullable Object[] arguments) throws InvocationTargetException {
        try {
            return this.getMethods()[idx].invoke(null, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public Method getMethod(int idx) {
        return this.getMethods()[idx];
    }

    protected Method[] getMethods() {
        if (this.result != null) {
            return this.result;
        }
        throw new IllegalStateException("\"cook()\" has not yet been called");
    }
}

