/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.util.reflect.ApiLog;
import org.codehaus.commons.compiler.util.resource.ListableResourceFinder;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

@NotNullByDefault(value=false)
final class ResourceFinderInputJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final JavaFileManager.Location location;
    private final JavaFileObject.Kind kind;
    private final ResourceFinder resourceFinder;
    private final Charset encoding;

    ResourceFinderInputJavaFileManager(JavaFileManager delegate, JavaFileManager.Location location, JavaFileObject.Kind kind, ResourceFinder resourceFinder, Charset encoding) {
        super(delegate);
        assert (resourceFinder != null);
        this.location = location;
        this.kind = kind;
        this.resourceFinder = resourceFinder;
        this.encoding = encoding;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (!(file instanceof ResourceJavaFileObject)) {
            String result = super.inferBinaryName(location, file);
            assert (result != null);
            return result;
        }
        String bn = file.getName();
        if (bn.startsWith("/")) {
            bn = bn.substring(1);
        }
        if (file.getKind() == JavaFileObject.Kind.SOURCE) {
            assert (bn.endsWith(".java")) : bn;
            bn = bn.substring(0, bn.length() - 5);
            bn = bn.replace('/', '.');
        } else if (file.getKind() == JavaFileObject.Kind.CLASS) {
            assert (bn.endsWith(".class")) : bn;
            bn = bn.substring(0, bn.length() - 6);
            bn = bn.replace('/', '.');
        }
        assert (bn != null) : file.toString();
        if (bn.startsWith(".")) {
            System.currentTimeMillis();
            file.getName();
        }
        return bn;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == this.location || super.hasLocation(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == this.location && kinds.contains((Object)this.kind)) {
            assert (this.resourceFinder instanceof ListableResourceFinder) : this.resourceFinder;
            ListableResourceFinder lrf = (ListableResourceFinder)this.resourceFinder;
            Iterable resources = lrf.list(packageName.replace('.', '/'), recurse);
            if (resources != null) {
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
                for (Resource r : resources) {
                    JavaFileObject jfo;
                    String className = r.getFileName().replace(File.separatorChar, '.');
                    className = className.replace('/', '.');
                    int idx = className.indexOf(packageName);
                    assert (idx != -1) : className + "//" + packageName;
                    if ((className = className.substring(idx)).endsWith(".java")) {
                        className = className.substring(0, className.length() - 5);
                    } else if (className.endsWith(".class") && this.kind == JavaFileObject.Kind.CLASS) {
                        className = className.substring(0, className.length() - 6);
                    }
                    if ((jfo = this.getJavaFileForInput(location, className, this.kind)) == null) continue;
                    result.add(jfo);
                }
                return result;
            }
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        assert (location != null);
        assert (className != null);
        assert (kind != null);
        if (location == this.location && kind == this.kind) {
            Resource resource = this.resourceFinder.findResource(className.replace('.', '/') + kind.extension);
            if (resource == null) {
                return null;
            }
            JavaFileObject result = new ResourceJavaFileObject(resource, className, kind);
            result = (JavaFileObject)ApiLog.logMethodInvocations((Object)result);
            return result;
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    public class ResourceJavaFileObject
    extends SimpleJavaFileObject {
        private final Resource resource;

        ResourceJavaFileObject(Resource resource, String className, JavaFileObject.Kind kind) {
            super(URI.create("bytearray:///" + className.replace('.', '/') + kind.extension), kind);
            this.resource = resource;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.resource.open();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return ResourceFinderInputJavaFileManager.this.encoding == null ? new InputStreamReader(this.resource.open()) : new InputStreamReader(this.resource.open(), ResourceFinderInputJavaFileManager.this.encoding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            Reader r = this.openReader(true);
            try {
                String string = Cookable.readString((Reader)r);
                return string;
            }
            finally {
                r.close();
            }
        }

        @Override
        public long getLastModified() {
            return this.resource.lastModified();
        }
    }
}

