/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.commons.io.LineAndColumnTracker;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

public final class Writers {
    private Writers() {
    }

    public static Writer onFirstChar(Writer out, final Runnable runnable) {
        return new FilterWriter(out){
            private boolean hadChars;

            @Override
            public void write(int c) throws IOException {
                this.aboutToWrite();
                super.write(c);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.aboutToWrite();
                super.write(cbuf, off, len);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str, int off, int len) throws IOException {
                this.aboutToWrite();
                super.write(str, off, len);
            }

            private void aboutToWrite() {
                if (!this.hadChars) {
                    runnable.run();
                    this.hadChars = true;
                }
            }
        };
    }

    public static Writer trackLineAndColumn(Writer out, final LineAndColumnTracker tracker) {
        return new FilterWriter(out){

            @Override
            public void write(int c) throws IOException {
                super.write(c);
                tracker.consume((char)c);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(cbuf[off++]);
                    --len;
                }
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(str.charAt(off++));
                    --len;
                }
            }
        };
    }
}

