/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.Sandbox;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.jdk.ClassLoaders;
import org.codehaus.commons.compiler.jdk.JavaFileManagerClassLoader;
import org.codehaus.commons.nullanalysis.NotNullByDefault;
import org.codehaus.commons.nullanalysis.Nullable;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    @Nullable
    private ClassLoader result;
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    @Nullable
    private ErrorHandler optionalCompileErrorHandler;
    @Nullable
    private WarningHandler optionalWarningHandler;
    @Nullable
    private Permissions permissions;

    public ClassLoader getClassLoader() {
        ClassLoader cl = this.result;
        if (cl == null) {
            throw new IllegalStateException("Not yet cooked");
        }
        return cl;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public void setNoPermissions() {
        this.setPermissions(new Permissions());
    }

    public void cook(@Nullable String optionalFileName, final Reader r) throws CompileException, IOException {
        URI uri;
        try {
            uri = new URI("simplecompiler");
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        SimpleJavaFileObject compilationUnit = new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

            @Override
            public boolean isNameCompatible(@Nullable String simpleName, @Nullable JavaFileObject.Kind kind) {
                return true;
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return r;
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return Cookable.readString((Reader)this.openReader(ignoreEncodingErrors));
            }

            @Override
            public String toString() {
                return String.valueOf(this.uri);
            }
        };
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompileException("JDK Java compiler not available - probably you're running a JRE, not a JDK", null);
        }
        final JavaFileManager fileManager = new JavaFileManager(){
            Map<String, JavaFileObject> classFiles = new HashMap<String, JavaFileObject>();

            @Override
            @NotNullByDefault(value=false)
            public ClassLoader getClassLoader(JavaFileManager.Location location) {
                return null;
            }

            @Override
            @NotNullByDefault(value=false)
            public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                if (!kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                    return Collections.emptyList();
                }
                String namePrefix = packageName.isEmpty() ? "" : packageName.replace('.', '/') + '/';
                Map<String, URL> allSubresources = ClassLoaders.getSubresources(SimpleCompiler.this.parentClassLoader, namePrefix, false, recurse);
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(allSubresources.size());
                for (Map.Entry<String, URL> e : allSubresources.entrySet()) {
                    URI subresourceUri;
                    final String name = e.getKey();
                    final URL url = e.getValue();
                    if (!name.endsWith(".class")) continue;
                    try {
                        subresourceUri = url.toURI();
                    }
                    catch (URISyntaxException use) {
                        throw new AssertionError((Object)use);
                    }
                    result.add(new JavaFileObject(){

                        @Override
                        public URI toUri() {
                            return subresourceUri;
                        }

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public InputStream openInputStream() throws IOException {
                            return url.openStream();
                        }

                        @Override
                        public JavaFileObject.Kind getKind() {
                            return JavaFileObject.Kind.CLASS;
                        }

                        @Override
                        public OutputStream openOutputStream() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Reader openReader(boolean ignoreEncodingErrors) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Writer openWriter() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public long getLastModified() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean delete() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public NestingKind getNestingKind() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Modifier getAccessLevel() {
                            throw new UnsupportedOperationException();
                        }

                        public String toString() {
                            return name + " from " + this.getClass().getSimpleName();
                        }
                    });
                }
                return result;
            }

            @Override
            @NotNullByDefault(value=false)
            public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                String result = file.getName();
                return result.substring(0, result.lastIndexOf(46)).replace('/', '.');
            }

            @Override
            public boolean hasLocation(@Nullable JavaFileManager.Location location) {
                return location == StandardLocation.CLASS_PATH;
            }

            @Override
            @NotNullByDefault(value=false)
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                if (location != StandardLocation.CLASS_OUTPUT) {
                    throw new UnsupportedOperationException();
                }
                return this.classFiles.get(className);
            }

            @Override
            @NotNullByDefault(value=false)
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                if (location != StandardLocation.CLASS_OUTPUT) {
                    throw new UnsupportedOperationException();
                }
                if (kind != JavaFileObject.Kind.CLASS) {
                    throw new UnsupportedOperationException();
                }
                SimpleJavaFileObject fileObject = new SimpleJavaFileObject(URI.create("bytearray:///" + className.replace('.', '/') + kind.extension), JavaFileObject.Kind.CLASS){
                    final ByteArrayOutputStream buffer;
                    {
                        this.buffer = new ByteArrayOutputStream();
                    }

                    @Override
                    public OutputStream openOutputStream() throws IOException {
                        return this.buffer;
                    }

                    @Override
                    public InputStream openInputStream() throws IOException {
                        return new ByteArrayInputStream(this.buffer.toByteArray());
                    }
                };
                this.classFiles.put(className, fileObject);
                return fileObject;
            }

            @Override
            @NotNullByDefault(value=false)
            public boolean isSameFile(FileObject a, FileObject b) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNullByDefault(value=false)
            public boolean handleOption(String current, Iterator<String> remaining) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNullByDefault(value=false)
            public int isSupportedOption(String option) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNullByDefault(value=false)
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNullByDefault(value=false)
            public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        try {
            final CompileException[] caughtCompileException = new CompileException[1];
            if (!compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(@Nullable Diagnostic<? extends JavaFileObject> diagnostic) {
                    block8: {
                        assert (diagnostic != null);
                        Location loc = new Location(null, (int)((short)diagnostic.getLineNumber()), (int)((short)diagnostic.getColumnNumber()));
                        String message = diagnostic.getMessage(null) + " (" + diagnostic.getCode() + ")";
                        try {
                            switch (diagnostic.getKind()) {
                                case ERROR: {
                                    ErrorHandler oceh = SimpleCompiler.this.optionalCompileErrorHandler;
                                    if (oceh == null) {
                                        throw new CompileException(message, loc);
                                    }
                                    oceh.handleError(message, loc);
                                    break;
                                }
                                case MANDATORY_WARNING: 
                                case WARNING: {
                                    WarningHandler owh = SimpleCompiler.this.optionalWarningHandler;
                                    if (owh == null) break;
                                    owh.handleWarning(null, message, loc);
                                    break;
                                }
                            }
                        }
                        catch (CompileException ce) {
                            if (caughtCompileException[0] != null) break block8;
                            caughtCompileException[0] = ce;
                        }
                    }
                }
            }, Collections.singletonList(this.debugSource ? "-g:source" + (this.debugLines ? ",lines" : "") + (this.debugVars ? ",vars" : "") : (this.debugLines ? "-g:lines" + (this.debugVars ? ",vars" : "") : (this.debugVars ? "-g:vars" : "-g:none"))), null, Collections.singleton(compilationUnit)).call().booleanValue()) {
                if (caughtCompileException[0] != null) {
                    throw caughtCompileException[0];
                }
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            for (Throwable t = rte.getCause(); t != null; t = t.getCause()) {
                if (t instanceof CompileException) {
                    throw (CompileException)t;
                }
                if (!(t instanceof IOException)) continue;
                throw (IOException)t;
            }
            throw rte;
        }
        finally {
            fileManager.close();
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<JavaFileManagerClassLoader>(){

            @Override
            public JavaFileManagerClassLoader run() {
                return new JavaFileManagerClassLoader(fileManager, SimpleCompiler.this.parentClassLoader);
            }
        });
        if (this.permissions != null) {
            Sandbox.confine((ClassLoader)cl, (PermissionCollection)this.permissions);
        }
        this.result = cl;
    }

    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    public void setParentClassLoader(@Nullable ClassLoader optionalParentClassLoader) {
        this.parentClassLoader = optionalParentClassLoader != null ? optionalParentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Deprecated
    public void setParentClassLoader(@Nullable ClassLoader optionalParentClassLoader, Class<?>[] auxiliaryClasses) {
        this.setParentClassLoader(optionalParentClassLoader);
    }

    public void setCompileErrorHandler(@Nullable ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }
}

