/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.commons.compiler.jdk.ClassBodyEvaluator;
import org.codehaus.commons.compiler.jdk.ScriptEvaluator;
import org.codehaus.commons.nullanalysis.Nullable;

public class ExpressionEvaluator
extends ScriptEvaluator
implements IExpressionEvaluator {
    @Nullable
    private Class<?>[] optionalExpressionTypes;

    public ExpressionEvaluator(String expression, Class<?> expressionType, String[] parameterNames, Class<?>[] parameterTypes) throws CompileException {
        this.setExpressionType(expressionType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(expression);
    }

    public ExpressionEvaluator(String expression, Class<?> expressionType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException {
        this.setExpressionType(expressionType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(expression);
    }

    public ExpressionEvaluator(String expression, Class<?> expressionType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, @Nullable ClassLoader optionalParentClassLoader) throws CompileException {
        this.setExpressionType(expressionType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(expression);
    }

    public ExpressionEvaluator() {
    }

    public void setExpressionType(@Nullable Class expressionType) {
        this.setExpressionTypes(new Class[]{expressionType});
    }

    public void setExpressionTypes(Class[] expressionTypes) {
        this.assertNotCooked();
        this.optionalExpressionTypes = expressionTypes;
        Class[] returnTypes = new Class[expressionTypes.length];
        for (int i = 0; i < returnTypes.length; ++i) {
            Class et = expressionTypes[i];
            returnTypes[i] = et == IExpressionEvaluator.ANY_TYPE ? Object.class : et;
        }
        super.setReturnTypes(returnTypes);
    }

    @Override
    @Deprecated
    public final void setReturnType(Class returnType) {
        throw new AssertionError((Object)"Must not be used on an ExpressionEvaluator; use 'setExpressionType()' instead");
    }

    @Override
    @Deprecated
    public final void setReturnTypes(Class[] returnTypes) {
        throw new AssertionError((Object)"Must not be used on an ExpressionEvaluator; use 'setExpressionTypes()' instead");
    }

    @Override
    protected Class<?> getDefaultReturnType() {
        return Object.class;
    }

    @Override
    public void cook(@Nullable String[] optionalFileNames, Reader[] readers) throws CompileException, IOException {
        String[] imports;
        if ((readers = (Reader[])readers.clone()).length == 1) {
            if (!readers[0].markSupported()) {
                readers[0] = new BufferedReader(readers[0]);
            }
            imports = ClassBodyEvaluator.parseImportDeclarations(readers[0]);
        } else {
            imports = new String[]{};
        }
        Class<?>[] oets = this.optionalExpressionTypes;
        Class[] returnTypes = new Class[readers.length];
        for (int i = 0; i < readers.length; ++i) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (oets == null || oets[i] == IExpressionEvaluator.ANY_TYPE) {
                returnTypes[i] = Object.class;
                pw.print("return org.codehaus.commons.compiler.PrimitiveWrapper.wrap(");
                pw.write(Cookable.readString((Reader)readers[i]));
                pw.println(");");
            } else {
                returnTypes[i] = oets[i];
                if (returnTypes[i] != Void.TYPE && returnTypes[i] != Void.class) {
                    pw.print("return ");
                }
                pw.write(Cookable.readString((Reader)readers[i]));
                pw.println(";");
            }
            pw.close();
            readers[i] = new StringReader(sw.toString());
        }
        super.setReturnTypes(returnTypes);
        this.cook(optionalFileNames, readers, imports);
    }
}

