/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.jdk.ClassBodyEvaluator;
import org.codehaus.commons.io.MultiReader;

public class ScriptEvaluator
extends ClassBodyEvaluator
implements IScriptEvaluator {
    protected boolean[] optionalOverrideMethod;
    protected boolean[] optionalStaticMethod;
    private Class<?>[] optionalReturnTypes;
    private String[] optionalMethodNames;
    private String[][] optionalParameterNames;
    private Class<?>[][] optionalParameterTypes;
    private Class<?>[][] optionalThrownExceptions;
    private Method[] result;

    public ScriptEvaluator(String script) throws CompileException {
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType) throws CompileException {
        this.setReturnType(returnType);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator(String optionalFileName, InputStream is, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, is);
    }

    public ScriptEvaluator(String optionalFileName, Reader reader, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, reader);
    }

    public ScriptEvaluator() {
    }

    public void setOverrideMethod(boolean overrideMethod) {
        this.setOverrideMethod(new boolean[]{overrideMethod});
    }

    public void setStaticMethod(boolean staticMethod) {
        this.setStaticMethod(new boolean[]{staticMethod});
    }

    public void setReturnType(Class returnType) {
        this.setReturnTypes(new Class[]{returnType});
    }

    public void setMethodName(String methodName) {
        this.setMethodNames(new String[]{methodName});
    }

    public void setParameters(String[] names, Class[] types) {
        this.setParameters(new String[][]{names}, new Class[][]{types});
    }

    public void setThrownExceptions(Class[] thrownExceptions) {
        this.setThrownExceptions(new Class[][]{thrownExceptions});
    }

    @Override
    public void cook(String optionalFileName, Reader r) throws CompileException, IOException {
        this.cook(new String[]{optionalFileName}, new Reader[]{r});
    }

    public Object evaluate(Object[] arguments) throws InvocationTargetException {
        return this.evaluate(0, arguments);
    }

    public Method getMethod() {
        return this.getMethod(0);
    }

    public void setOverrideMethod(boolean[] overrideMethod) {
        this.assertNotCooked();
        this.optionalOverrideMethod = (boolean[])overrideMethod.clone();
    }

    public void setStaticMethod(boolean[] staticMethod) {
        this.assertNotCooked();
        this.optionalStaticMethod = (boolean[])staticMethod.clone();
    }

    public void setReturnTypes(Class[] returnTypes) {
        this.assertNotCooked();
        this.optionalReturnTypes = (Class[])returnTypes.clone();
    }

    public void setMethodNames(String[] methodNames) {
        this.assertNotCooked();
        this.optionalMethodNames = (String[])methodNames.clone();
    }

    public void setParameters(String[][] names, Class[][] types) {
        this.assertNotCooked();
        this.optionalParameterNames = (String[][])names.clone();
        this.optionalParameterTypes = (Class[][])types.clone();
    }

    public void setThrownExceptions(Class[][] thrownExceptions) {
        this.assertNotCooked();
        this.optionalThrownExceptions = (Class[][])thrownExceptions.clone();
    }

    public final void cook(Reader[] readers) throws CompileException, IOException {
        this.cook(null, readers);
    }

    public void cook(String[] optionalFileNames, Reader[] readers) throws CompileException, IOException {
        String[] imports;
        if (readers.length == 1) {
            if (!readers[0].markSupported()) {
                readers = new Reader[]{new BufferedReader(readers[0])};
            }
            imports = ClassBodyEvaluator.parseImportDeclarations(readers[0]);
        } else {
            imports = new String[]{};
        }
        this.cook(optionalFileNames, readers, imports);
    }

    public final void cook(String[] strings) throws CompileException {
        this.cook(null, strings);
    }

    public void cook(String[] optionalFileNames, String[] strings) throws CompileException {
        Reader[] readers = new Reader[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            readers[i] = new StringReader(strings[i]);
        }
        try {
            this.cook(optionalFileNames, readers);
        }
        catch (IOException ioe) {
            throw new RuntimeException("SNO: IOException despite StringReader", ioe);
        }
    }

    protected final void cook(String[] optionalFileNames, Reader[] readers, String[] imports) throws CompileException, IOException {
        String[] methodNames;
        int count = readers.length;
        if (this.optionalMethodNames != null && this.optionalMethodNames.length != count) {
            throw new IllegalStateException("methodName");
        }
        if (this.optionalParameterNames != null && this.optionalParameterNames.length != count) {
            throw new IllegalStateException("parameterNames");
        }
        if (this.optionalParameterTypes != null && this.optionalParameterTypes.length != count) {
            throw new IllegalStateException("parameterTypes");
        }
        if (this.optionalReturnTypes != null && this.optionalReturnTypes.length != count) {
            throw new IllegalStateException("returnTypes");
        }
        if (this.optionalOverrideMethod != null && this.optionalOverrideMethod.length != count) {
            throw new IllegalStateException("overrideMethod");
        }
        if (this.optionalStaticMethod != null && this.optionalStaticMethod.length != count) {
            throw new IllegalStateException("staticMethod");
        }
        if (this.optionalThrownExceptions != null && this.optionalThrownExceptions.length != count) {
            throw new IllegalStateException("thrownExceptions");
        }
        if (this.optionalMethodNames == null) {
            methodNames = new String[count];
            for (int i = 0; i < count; ++i) {
                methodNames[i] = "eval" + i;
            }
        } else {
            methodNames = this.optionalMethodNames;
        }
        ArrayList<Reader> classBody = new ArrayList<Reader>();
        for (int i = 0; i < count; ++i) {
            int j;
            boolean overrideMethod = this.optionalOverrideMethod != null && this.optionalOverrideMethod[i];
            boolean staticMethod = this.optionalStaticMethod == null || this.optionalStaticMethod[i];
            Class<?> returnType = this.optionalReturnTypes == null ? this.getDefaultReturnType() : this.optionalReturnTypes[i];
            String[] parameterNames = this.optionalParameterNames == null ? new String[]{} : this.optionalParameterNames[i];
            Class[] parameterTypes = this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i];
            Class[] thrownExceptions = this.optionalThrownExceptions == null ? new Class[]{} : this.optionalThrownExceptions[i];
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (overrideMethod) {
                pw.print("@Override ");
            }
            pw.print("public ");
            if (staticMethod) {
                pw.print("static ");
            }
            pw.print(returnType.getName());
            pw.print(" ");
            pw.print(methodNames[i]);
            pw.print("(");
            for (j = 0; j < parameterNames.length; ++j) {
                if (j > 0) {
                    pw.print(", ");
                }
                pw.print(parameterTypes[j].getName());
                pw.print(" ");
                pw.print(parameterNames[j]);
            }
            pw.print(")");
            for (j = 0; j < thrownExceptions.length; ++j) {
                pw.print(j == 0 ? " throws " : ", ");
                pw.print(thrownExceptions[j].getName());
            }
            pw.println(" {");
            pw.close();
            classBody.add(new StringReader(sw.toString()));
            classBody.add(readers[i]);
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            pw.println("}");
            pw.close();
            classBody.add(new StringReader(sw.toString()));
        }
        super.cook(optionalFileNames == null ? null : optionalFileNames[0], imports, new MultiReader(classBody));
        Class<?> c = this.getClazz();
        this.result = new Method[count];
        if (count <= 10) {
            for (int i = 0; i < count; ++i) {
                try {
                    this.result[i] = c.getDeclaredMethod(methodNames[i], this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException("SNO: Loaded class does not declare method \"" + methodNames[i] + "\"", ex);
                }
            }
        } else {
            Method[] ma = c.getDeclaredMethods();
            class MethodWrapper {
                private final String name;
                private final Class<?>[] parameterTypes;

                MethodWrapper(String name, Class<?>[] parameterTypes) {
                    this.name = name;
                    this.parameterTypes = parameterTypes;
                }

                public boolean equals(Object o) {
                    if (!(o instanceof MethodWrapper)) {
                        return false;
                    }
                    MethodWrapper that = (MethodWrapper)o;
                    return this.name.equals(that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
                }

                public int hashCode() {
                    return this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
                }
            }
            HashMap<MethodWrapper, Method> dms = new HashMap<MethodWrapper, Method>(2 * count);
            for (Method m : ma) {
                dms.put(new MethodWrapper(m.getName(), m.getParameterTypes()), m);
            }
            for (int i = 0; i < count; ++i) {
                Method m = (Method)dms.get(new MethodWrapper(methodNames[i], this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i]));
                if (m == null) {
                    throw new RuntimeException("SNO: Loaded class does not declare method \"" + methodNames[i] + "\"");
                }
                this.result[i] = m;
            }
        }
    }

    protected Class<?> getDefaultReturnType() {
        return Void.TYPE;
    }

    public Object createFastEvaluator(String script, Class interfaceToImplement, String[] parameterNames) throws CompileException {
        try {
            return this.createFastEvaluator(new StringReader(script), interfaceToImplement, parameterNames);
        }
        catch (IOException ioe) {
            throw new RuntimeException("SNO: IOException despite StringReader", ioe);
        }
    }

    @Override
    public final Object createInstance(Reader reader) {
        throw new UnsupportedOperationException("createInstance");
    }

    public Object createFastEvaluator(Reader r, Class interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        if (!interfaceToImplement.isInterface()) {
            throw new RuntimeException("\"" + interfaceToImplement + "\" is not an interface");
        }
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new RuntimeException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        this.setImplementedInterfaces(new Class[]{interfaceToImplement});
        this.setStaticMethod(false);
        if (this instanceof IExpressionEvaluator) {
            ((IExpressionEvaluator)this).setExpressionType(methodToImplement.getReturnType());
        } else {
            this.setReturnType(methodToImplement.getReturnType());
        }
        this.setMethodName(methodToImplement.getName());
        this.setParameters(parameterNames, methodToImplement.getParameterTypes());
        this.setThrownExceptions(methodToImplement.getExceptionTypes());
        this.cook(r);
        Class<?> c = this.getMethod().getDeclaringClass();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("SNO - Declared class is always non-abstract", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("SNO - interface methods are always PUBLIC", e);
        }
    }

    public Object evaluate(int idx, Object[] arguments) throws InvocationTargetException {
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        try {
            return this.result[idx].invoke(null, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public Method getMethod(int idx) {
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.result[idx];
    }
}

