/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.xc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.Versioned;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.jsontype.impl.StdTypeResolverBuilder;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.util.VersionUtil;
import org.codehaus.jackson.xc.XmlAdapterJsonDeserializer;
import org.codehaus.jackson.xc.XmlAdapterJsonSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbAnnotationIntrospector
extends AnnotationIntrospector
implements Versioned {
    protected static final String MARKER_FOR_DEFAULT = "##default";
    protected final String _jaxbPackageName = XmlElement.class.getPackage().getName();
    protected final JsonSerializer<?> _dataHandlerSerializer;
    protected final JsonDeserializer<?> _dataHandlerDeserializer;
    private static final ThreadLocal<SoftReference<PropertyDescriptors>> _propertyDescriptors = new ThreadLocal();

    public JaxbAnnotationIntrospector() {
        JsonSerializer dataHandlerSerializer = null;
        JsonDeserializer dataHandlerDeserializer = null;
        try {
            dataHandlerSerializer = (JsonSerializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonSerializer").newInstance();
            dataHandlerDeserializer = (JsonDeserializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonDeserializer").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._dataHandlerSerializer = dataHandlerSerializer;
        this._dataHandlerDeserializer = dataHandlerDeserializer;
    }

    public Version version() {
        return VersionUtil.versionFor(((Object)((Object)this)).getClass());
    }

    public boolean isHandled(Annotation ann) {
        String pkgName;
        Class<? extends Annotation> cls = ann.annotationType();
        Package pkg = cls.getPackage();
        String string = pkgName = pkg != null ? pkg.getName() : cls.getName();
        if (pkgName.startsWith(this._jaxbPackageName)) {
            return true;
        }
        return cls == JsonCachable.class;
    }

    public Boolean findCachability(AnnotatedClass ac) {
        JsonCachable ann = (JsonCachable)ac.getAnnotation(JsonCachable.class);
        if (ann != null) {
            return ann.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public String findRootName(AnnotatedClass ac) {
        XmlRootElement elem = this.findRootElementAnnotation(ac);
        if (elem != null) {
            String name = elem.name();
            return MARKER_FOR_DEFAULT.equals(name) ? "" : name;
        }
        return null;
    }

    public String[] findPropertiesToIgnore(AnnotatedClass ac) {
        return null;
    }

    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
        return null;
    }

    public Boolean isIgnorableType(AnnotatedClass ac) {
        return null;
    }

    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        XmlAccessType at = this.findAccessType((Annotated)ac);
        if (at == null) {
            return checker;
        }
        switch (at) {
            case FIELD: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case NONE: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case PROPERTY: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
            case PUBLIC_MEMBER: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
        }
        return checker;
    }

    protected boolean isPropertiesAccessible(Annotated ac) {
        XmlAccessType accessType = this.findAccessType(ac);
        if (accessType == null) {
            accessType = XmlAccessType.PUBLIC_MEMBER;
        }
        return accessType == XmlAccessType.PUBLIC_MEMBER || accessType == XmlAccessType.PROPERTY;
    }

    protected XmlAccessType findAccessType(Annotated ac) {
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, ac, true, true, true);
        return at == null ? null : at.value();
    }

    public TypeResolverBuilder<?> findTypeResolver(AnnotatedClass ac, JavaType baseType) {
        return null;
    }

    public TypeResolverBuilder<?> findPropertyTypeResolver(AnnotatedMember am, JavaType baseType) {
        if (baseType.isContainerType()) {
            return null;
        }
        return this._typeResolverFromXmlElements(am);
    }

    public TypeResolverBuilder<?> findPropertyContentTypeResolver(AnnotatedMember am, JavaType containerType) {
        if (!containerType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + containerType + ")");
        }
        return this._typeResolverFromXmlElements(am);
    }

    protected TypeResolverBuilder<?> _typeResolverFromXmlElements(AnnotatedMember am) {
        XmlElements elems = this.findAnnotation(XmlElements.class, (Annotated)am, false, false, false);
        XmlElementRefs elemRefs = this.findAnnotation(XmlElementRefs.class, (Annotated)am, false, false, false);
        if (elems == null && elemRefs == null) {
            return null;
        }
        StdTypeResolverBuilder b = new StdTypeResolverBuilder();
        b = b.init(JsonTypeInfo.Id.NAME, null);
        b = b.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT);
        return b;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        XmlElements elems = this.findAnnotation(XmlElements.class, a, false, false, false);
        if (elems != null) {
            ArrayList<NamedType> result = new ArrayList<NamedType>();
            for (XmlElement elem : elems.value()) {
                String name = elem.name();
                if (MARKER_FOR_DEFAULT.equals(name)) {
                    name = null;
                }
                result.add(new NamedType(elem.type(), name));
            }
            return result;
        }
        XmlElementRefs elemRefs = this.findAnnotation(XmlElementRefs.class, a, false, false, false);
        if (elemRefs != null) {
            ArrayList<NamedType> result = new ArrayList<NamedType>();
            for (XmlElementRef elemRef : elemRefs.value()) {
                XmlRootElement rootElement;
                Class refType = elemRef.type();
                if (JAXBElement.class.isAssignableFrom(refType)) continue;
                String name = elemRef.name();
                if ((name == null || MARKER_FOR_DEFAULT.equals(name)) && (rootElement = refType.getAnnotation(XmlRootElement.class)) != null) {
                    name = rootElement.name();
                }
                if (name == null || MARKER_FOR_DEFAULT.equals(name)) {
                    name = Introspector.decapitalize(refType.getSimpleName());
                }
                result.add(new NamedType(refType, name));
            }
            return result;
        }
        return null;
    }

    public String findTypeName(AnnotatedClass ac) {
        String name;
        XmlType type = this.findAnnotation(XmlType.class, (Annotated)ac, false, false, false);
        if (type != null && !MARKER_FOR_DEFAULT.equals(name = type.name())) {
            return name;
        }
        return null;
    }

    public boolean isIgnorableMethod(AnnotatedMethod m) {
        return m.getAnnotation(XmlTransient.class) != null;
    }

    public boolean isIgnorableConstructor(AnnotatedConstructor c) {
        return false;
    }

    public boolean isIgnorableField(AnnotatedField f) {
        return f.getAnnotation(XmlTransient.class) != null;
    }

    public JsonSerializer<?> findSerializer(Annotated am, BeanProperty property) {
        XmlAdapter<Object, Object> adapter = this.findAdapter(am, true);
        if (adapter != null) {
            return new XmlAdapterJsonSerializer(adapter, property);
        }
        Class type = am.getRawType();
        if (type != null && this._dataHandlerSerializer != null && this.isDataHandler(type)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class<?> type) {
        return type != null && !Object.class.equals(type) && ("javax.activation.DataHandler".equals(type.getName()) || this.isDataHandler(type.getSuperclass()));
    }

    public Class<?> findSerializationType(Annotated a) {
        XmlElement annotation = this.findAnnotation(XmlElement.class, a, false, false, false);
        if (annotation == null || annotation.type() == XmlElement.DEFAULT.class) {
            return null;
        }
        Class rawPropType = a.getRawType();
        if (this.isIndexedType(rawPropType)) {
            return null;
        }
        return annotation.type();
    }

    public JsonSerialize.Inclusion findSerializationInclusion(Annotated a, JsonSerialize.Inclusion defValue) {
        XmlElementWrapper w = (XmlElementWrapper)a.getAnnotation(XmlElementWrapper.class);
        if (w != null) {
            return w.nillable() ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
        }
        XmlElement e = (XmlElement)a.getAnnotation(XmlElement.class);
        if (e != null) {
            return e.nillable() ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
        }
        return defValue;
    }

    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        return null;
    }

    public Class<?>[] findSerializationViews(Annotated a) {
        return null;
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        XmlType type = this.findAnnotation(XmlType.class, (Annotated)ac, true, true, true);
        if (type == null) {
            return null;
        }
        String[] order = type.propOrder();
        if (order == null || order.length == 0) {
            return null;
        }
        PropertyDescriptors props = this.getDescriptors(ac.getRawType());
        int len = order.length;
        for (int i = 0; i < len; ++i) {
            PropertyDescriptor desc;
            String propName = order[i];
            if (props.findByPropertyName(propName) != null || propName.length() == 0) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("get");
            sb.append(Character.toUpperCase(propName.charAt(0)));
            if (propName.length() > 1) {
                sb.append(propName.substring(1));
            }
            if ((desc = props.findByMethodName(sb.toString())) == null) continue;
            order[i] = desc.getName();
        }
        return order;
    }

    public Boolean findSerializationSortAlphabetically(AnnotatedClass ac) {
        XmlAccessorOrder order = this.findAnnotation(XmlAccessorOrder.class, (Annotated)ac, true, true, true);
        return order == null ? null : Boolean.valueOf(order.value() == XmlAccessOrder.ALPHABETICAL);
    }

    public String findGettablePropertyName(AnnotatedMethod am) {
        PropertyDescriptor desc = this.findPropertyDescriptor(am);
        if (desc != null) {
            return this.findJaxbSpecifiedPropertyName(desc);
        }
        return null;
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        return false;
    }

    public String findEnumValue(Enum<?> e) {
        Class<?> enumClass = e.getDeclaringClass();
        String enumValue = e.name();
        try {
            XmlEnumValue xmlEnumValue = enumClass.getDeclaredField(enumValue).getAnnotation(XmlEnumValue.class);
            return xmlEnumValue != null ? xmlEnumValue.value() : enumValue;
        }
        catch (NoSuchFieldException e1) {
            throw new IllegalStateException("Could not locate Enum entry '" + enumValue + "' (Enum class " + enumClass.getName() + ")", e1);
        }
    }

    public String findSerializablePropertyName(AnnotatedField af) {
        if (this.isInvisible(af)) {
            return null;
        }
        Field field = af.getAnnotated();
        String name = JaxbAnnotationIntrospector.findJaxbPropertyName(field, field.getType(), "");
        return name == null ? field.getName() : name;
    }

    public JsonDeserializer<?> findDeserializer(Annotated am, BeanProperty property) {
        XmlAdapter<Object, Object> adapter = this.findAdapter(am, false);
        if (adapter != null) {
            return new XmlAdapterJsonDeserializer(adapter, property);
        }
        Class type = am.getRawType();
        if (type != null && this._dataHandlerDeserializer != null && this.isDataHandler(type)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    public Class<KeyDeserializer> findKeyDeserializer(Annotated am) {
        return null;
    }

    public Class<JsonDeserializer<?>> findContentDeserializer(Annotated am) {
        return null;
    }

    public Class<?> findDeserializationType(Annotated a, JavaType baseType, String propName) {
        if (!baseType.isContainerType()) {
            return this._doFindDeserializationType(a, baseType, propName);
        }
        return null;
    }

    public Class<?> findDeserializationKeyType(Annotated am, JavaType baseKeyType, String propName) {
        return null;
    }

    public Class<?> findDeserializationContentType(Annotated a, JavaType baseContentType, String propName) {
        Class<?> type = this._doFindDeserializationType(a, baseContentType, propName);
        return type;
    }

    protected Class<?> _doFindDeserializationType(Annotated a, JavaType baseType, String propName) {
        AnnotatedMethod am;
        Class type;
        if (a.hasAnnotation(XmlJavaTypeAdapter.class)) {
            return null;
        }
        XmlElement annotation = this.findAnnotation(XmlElement.class, a, false, false, false);
        if (annotation != null && (type = annotation.type()) != XmlElement.DEFAULT.class) {
            return type;
        }
        if (a instanceof AnnotatedMethod && propName != null && (annotation = this.findFieldAnnotation(XmlElement.class, (am = (AnnotatedMethod)a).getDeclaringClass(), propName)) != null && annotation.type() != XmlElement.DEFAULT.class) {
            return annotation.type();
        }
        return null;
    }

    public String findSettablePropertyName(AnnotatedMethod am) {
        PropertyDescriptor desc = this.findPropertyDescriptor(am);
        if (desc != null) {
            return this.findJaxbSpecifiedPropertyName(desc);
        }
        return null;
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return false;
    }

    public boolean hasCreatorAnnotation(Annotated am) {
        return false;
    }

    public String findDeserializablePropertyName(AnnotatedField af) {
        if (this.isInvisible(af)) {
            return null;
        }
        Field field = af.getAnnotated();
        String name = JaxbAnnotationIntrospector.findJaxbPropertyName(field, field.getType(), "");
        return name == null ? field.getName() : name;
    }

    public String findPropertyNameForParam(AnnotatedParameter param) {
        return null;
    }

    protected boolean isInvisible(AnnotatedField f) {
        boolean invisible = true;
        for (Annotation annotation : f.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled(annotation)) continue;
            invisible = false;
        }
        if (invisible) {
            XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
            XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, (Annotated)f, true, true, true);
            if (at != null) {
                accessType = at.value();
            }
            invisible = accessType != XmlAccessType.FIELD && (accessType != XmlAccessType.PUBLIC_MEMBER || !Modifier.isPublic(f.getAnnotated().getModifiers()));
        }
        return invisible;
    }

    protected <A extends Annotation> A findAnnotation(Class<A> annotationClass, Annotated annotated, boolean includePackage, boolean includeClass, boolean includeSuperclasses) {
        Annotation annotation;
        A annotation2;
        PropertyDescriptor pd;
        if (annotated instanceof AnnotatedMethod && (pd = this.findPropertyDescriptor((AnnotatedMethod)annotated)) != null && (annotation2 = new AnnotatedProperty(pd).getAnnotation(annotationClass)) != null) {
            return annotation2;
        }
        AnnotatedElement annType = annotated.getAnnotated();
        Class memberClass = null;
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter param = (AnnotatedParameter)annotated;
            annotation = param.getAnnotation(annotationClass);
            if (annotation != null) {
                return (A)annotation;
            }
            memberClass = param.getMember().getDeclaringClass();
        } else {
            A annotation3 = annType.getAnnotation(annotationClass);
            if (annotation3 != null) {
                return annotation3;
            }
            if (annType instanceof Member) {
                memberClass = ((Member)((Object)annType)).getDeclaringClass();
                if (includeClass && (annotation3 = memberClass.getAnnotation(annotationClass)) != null) {
                    return annotation3;
                }
            } else if (annType instanceof Class) {
                memberClass = (Class)annType;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
        }
        if (memberClass != null) {
            if (includeSuperclasses) {
                for (Class superclass = memberClass.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                    annotation = superclass.getAnnotation(annotationClass);
                    if (annotation == null) continue;
                    return (A)annotation;
                }
            }
            if (includePackage) {
                return memberClass.getPackage().getAnnotation(annotationClass);
            }
        }
        return null;
    }

    protected <A extends Annotation> A findFieldAnnotation(Class<A> annotationType, Class<?> cls, String fieldName) {
        do {
            for (Field f : cls.getDeclaredFields()) {
                if (!fieldName.equals(f.getName())) continue;
                return f.getAnnotation(annotationType);
            }
        } while (!cls.isInterface() && cls != Object.class && (cls = cls.getSuperclass()) != null);
        return null;
    }

    protected PropertyDescriptors getDescriptors(Class<?> forClass) {
        PropertyDescriptors descriptors;
        SoftReference<PropertyDescriptors> ref = _propertyDescriptors.get();
        PropertyDescriptors propertyDescriptors = descriptors = ref == null ? null : ref.get();
        if (descriptors == null || descriptors.getBeanClass() != forClass) {
            try {
                descriptors = PropertyDescriptors.find(forClass);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Problem introspecting bean properties: " + e.getMessage(), e);
            }
            _propertyDescriptors.set(new SoftReference<PropertyDescriptors>(descriptors));
        }
        return descriptors;
    }

    protected PropertyDescriptor findPropertyDescriptor(AnnotatedMethod m) {
        PropertyDescriptors descs = this.getDescriptors(m.getDeclaringClass());
        PropertyDescriptor desc = descs.findByMethodName(m.getName());
        return desc;
    }

    protected String findJaxbSpecifiedPropertyName(PropertyDescriptor prop) {
        return JaxbAnnotationIntrospector.findJaxbPropertyName(new AnnotatedProperty(prop), prop.getPropertyType(), prop.getName());
    }

    protected static String findJaxbPropertyName(AnnotatedElement ae, Class<?> aeType, String defaultName) {
        XmlValue valueInfo;
        XmlElementWrapper elementWrapper = ae.getAnnotation(XmlElementWrapper.class);
        if (elementWrapper != null) {
            String name = elementWrapper.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlAttribute attribute = ae.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            String name = attribute.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElement element = ae.getAnnotation(XmlElement.class);
        if (element != null) {
            String name = element.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElementRef elementRef = ae.getAnnotation(XmlElementRef.class);
        if (elementRef != null) {
            XmlRootElement rootElement;
            String name = elementRef.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            if (aeType != null && (rootElement = aeType.getAnnotation(XmlRootElement.class)) != null) {
                name = rootElement.name();
                if (!MARKER_FOR_DEFAULT.equals(name)) {
                    return name;
                }
                return Introspector.decapitalize(aeType.getSimpleName());
            }
        }
        if ((valueInfo = ae.getAnnotation(XmlValue.class)) != null) {
            return "value";
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass ac) {
        return this.findAnnotation(XmlRootElement.class, (Annotated)ac, true, false, true);
    }

    protected XmlAdapter<Object, Object> findAdapter(Annotated am, boolean forSerialization) {
        XmlAdapter<Object, Object> adapter;
        XmlAdapter<Object, Object> adapter2;
        XmlJavaTypeAdapter adapterInfo;
        Class<?> potentialAdaptee;
        Member member;
        if (am instanceof AnnotatedClass) {
            return this.findAdapterForClass((AnnotatedClass)am, forSerialization);
        }
        Class memberType = am.getRawType();
        if (memberType == Void.TYPE && am instanceof AnnotatedMethod) {
            memberType = ((AnnotatedMethod)am).getParameterClass(0);
        }
        if ((member = (Member)((Object)am.getAnnotated())) != null && (potentialAdaptee = member.getDeclaringClass()) != null && (adapterInfo = potentialAdaptee.getAnnotation(XmlJavaTypeAdapter.class)) != null && (adapter2 = this.checkAdapter(adapterInfo, memberType)) != null) {
            return adapter2;
        }
        XmlJavaTypeAdapter adapterInfo2 = this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
        if (adapterInfo2 != null && (adapter = this.checkAdapter(adapterInfo2, memberType)) != null) {
            return adapter;
        }
        XmlJavaTypeAdapters adapters = this.findAnnotation(XmlJavaTypeAdapters.class, am, true, false, false);
        if (adapters != null) {
            for (XmlJavaTypeAdapter info : adapters.value()) {
                XmlAdapter<Object, Object> adapter3 = this.checkAdapter(info, memberType);
                if (adapter3 == null) continue;
                return adapter3;
            }
        }
        return null;
    }

    private final XmlAdapter<Object, Object> checkAdapter(XmlJavaTypeAdapter adapterInfo, Class<?> typeNeeded) {
        Class adaptedType = adapterInfo.type();
        if (adaptedType == XmlJavaTypeAdapter.DEFAULT.class || adaptedType.isAssignableFrom(typeNeeded)) {
            Class cls = adapterInfo.value();
            return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)false);
        }
        return null;
    }

    protected XmlAdapter<Object, Object> findAdapterForClass(AnnotatedClass ac, boolean forSerialization) {
        XmlJavaTypeAdapter adapterInfo = ac.getAnnotated().getAnnotation(XmlJavaTypeAdapter.class);
        if (adapterInfo != null) {
            Class cls = adapterInfo.value();
            return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)false);
        }
        return null;
    }

    protected boolean isIndexedType(Class<?> raw) {
        return raw.isArray() || Collection.class.isAssignableFrom(raw) || Map.class.isAssignableFrom(raw);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class PropertyDescriptors {
        private final Class<?> _forClass;
        private final List<PropertyDescriptor> _properties;
        private Map<String, PropertyDescriptor> _byMethodName;
        private Map<String, PropertyDescriptor> _byPropertyName;

        public PropertyDescriptors(Class<?> forClass, List<PropertyDescriptor> properties) {
            this._forClass = forClass;
            this._properties = properties;
        }

        public Class<?> getBeanClass() {
            return this._forClass;
        }

        public PropertyDescriptor findByPropertyName(String name) {
            if (this._byPropertyName == null) {
                this._byPropertyName = new HashMap<String, PropertyDescriptor>(this._properties.size());
                for (PropertyDescriptor desc : this._properties) {
                    this._byPropertyName.put(desc.getName(), desc);
                }
            }
            return this._byPropertyName.get(name);
        }

        public PropertyDescriptor findByMethodName(String name) {
            if (this._byMethodName == null) {
                this._byMethodName = new HashMap<String, PropertyDescriptor>(this._properties.size());
                for (PropertyDescriptor desc : this._properties) {
                    Method setter;
                    Method getter = desc.getReadMethod();
                    if (getter != null) {
                        this._byMethodName.put(getter.getName(), desc);
                    }
                    if ((setter = desc.getWriteMethod()) == null) continue;
                    this._byMethodName.put(setter.getName(), desc);
                }
            }
            return this._byMethodName.get(name);
        }

        public static PropertyDescriptors find(Class<?> forClass) throws IntrospectionException {
            List<PropertyDescriptor> descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(forClass);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            if (pds.length == 0) {
                descriptors = Collections.emptyList();
            } else {
                descriptors = new ArrayList();
                Map<String, PropertyDescriptor> partials = null;
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    String writeName;
                    Method read = pd.getReadMethod();
                    if (read != null && read.getAnnotation(XmlTransient.class) != null) {
                        read = null;
                    }
                    String readName = read == null ? null : JaxbAnnotationIntrospector.findJaxbPropertyName(read, pd.getPropertyType(), null);
                    Method write = pd.getWriteMethod();
                    if (write != null && write.getAnnotation(XmlTransient.class) != null) {
                        write = null;
                    }
                    if (read == null && write == null) continue;
                    String string = writeName = write == null ? null : JaxbAnnotationIntrospector.findJaxbPropertyName(write, pd.getPropertyType(), null);
                    if (write == null) {
                        if (readName == null) {
                            readName = pd.getName();
                        }
                        partials = PropertyDescriptors._processReadMethod(partials, read, readName, descriptors);
                        continue;
                    }
                    if (read == null) {
                        if (writeName == null) {
                            writeName = pd.getName();
                        }
                        partials = PropertyDescriptors._processWriteMethod(partials, write, writeName, descriptors);
                        continue;
                    }
                    if (readName != null && writeName != null && !readName.equals(writeName)) {
                        partials = PropertyDescriptors._processReadMethod(partials, read, readName, descriptors);
                        partials = PropertyDescriptors._processWriteMethod(partials, write, writeName, descriptors);
                        continue;
                    }
                    String name = readName != null ? readName : (writeName != null ? writeName : pd.getName());
                    descriptors.add(new PropertyDescriptor(name, read, write));
                }
            }
            return new PropertyDescriptors(forClass, descriptors);
        }

        private static Map<String, PropertyDescriptor> _processReadMethod(Map<String, PropertyDescriptor> partials, Method method, String propertyName, List<PropertyDescriptor> pds) throws IntrospectionException {
            PropertyDescriptor pd;
            if (partials == null) {
                partials = new HashMap<String, PropertyDescriptor>();
            } else {
                pd = partials.get(propertyName);
                if (pd != null) {
                    pd.setReadMethod(method);
                    if (pd.getWriteMethod() != null) {
                        pds.add(pd);
                        partials.remove(propertyName);
                        return partials;
                    }
                }
            }
            pd = new PropertyDescriptor(propertyName, method, null);
            partials.put(propertyName, pd);
            return partials;
        }

        private static Map<String, PropertyDescriptor> _processWriteMethod(Map<String, PropertyDescriptor> partials, Method method, String propertyName, List<PropertyDescriptor> pds) throws IntrospectionException {
            if (partials == null) {
                partials = new HashMap<String, PropertyDescriptor>();
            } else {
                PropertyDescriptor pd = partials.get(propertyName);
                if (pd != null) {
                    pd.setWriteMethod(method);
                    if (pd.getReadMethod() != null) {
                        pds.add(pd);
                        partials.remove(propertyName);
                        return partials;
                    }
                }
            }
            partials.put(propertyName, new PropertyDescriptor(propertyName, null, method));
            return partials;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedProperty
    implements AnnotatedElement {
        private final PropertyDescriptor pd;

        private AnnotatedProperty(PropertyDescriptor pd) {
            this.pd = pd;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            Method m = this.pd.getReadMethod();
            if (m != null && m.isAnnotationPresent(annotationClass)) {
                return true;
            }
            m = this.pd.getWriteMethod();
            return m != null && m.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            T ann;
            Method m = this.pd.getReadMethod();
            if (m != null && (ann = m.getAnnotation(annotationClass)) != null) {
                return ann;
            }
            m = this.pd.getWriteMethod();
            if (m != null) {
                return m.getAnnotation(annotationClass);
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            throw new UnsupportedOperationException();
        }
    }
}

