/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.xc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.xc.XmlAdapterJsonDeserializer;
import org.codehaus.jackson.xc.XmlAdapterJsonSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbAnnotationIntrospector
extends AnnotationIntrospector {
    static final String MARKER_FOR_DEFAULT = "##default";
    final String _jaxbPackageName = XmlElement.class.getPackage().getName();
    final JsonSerializer<?> _dataHandlerSerializer;
    final JsonDeserializer<?> _dataHandlerDeserializer;

    public JaxbAnnotationIntrospector() {
        JsonSerializer dataHandlerSerializer = null;
        JsonDeserializer dataHandlerDeserializer = null;
        try {
            dataHandlerSerializer = (JsonSerializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonSerializer").newInstance();
            dataHandlerDeserializer = (JsonDeserializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonDeserializer").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._dataHandlerSerializer = dataHandlerSerializer;
        this._dataHandlerDeserializer = dataHandlerDeserializer;
    }

    public boolean isHandled(Annotation ann) {
        Class<? extends Annotation> cls = ann.annotationType();
        Package pkg = cls.getPackage();
        if (pkg != null) {
            return pkg.getName().startsWith(this._jaxbPackageName);
        }
        return cls.getName().startsWith(this._jaxbPackageName);
    }

    public String findNamespace(Annotated ann) {
        String ns = null;
        if (ann instanceof AnnotatedClass) {
            XmlRootElement elem = this.findRootElementAnnotation((AnnotatedClass)ann);
            if (elem != null) {
                ns = elem.namespace();
            }
        } else {
            XmlAttribute attr;
            XmlElement elem = this.findAnnotation(XmlElement.class, ann, false, false, false);
            if (elem != null) {
                ns = elem.namespace();
            }
            if ((ns == null || MARKER_FOR_DEFAULT.equals(ns)) && (attr = this.findAnnotation(XmlAttribute.class, ann, false, false, false)) != null) {
                ns = attr.namespace();
            }
        }
        if (MARKER_FOR_DEFAULT.equals(ns)) {
            ns = null;
        }
        return ns;
    }

    public Boolean findCachability(AnnotatedClass ac) {
        return null;
    }

    public Boolean findFieldAutoDetection(AnnotatedClass ac) {
        return this.isFieldsAccessible((Annotated)ac);
    }

    public String findRootName(AnnotatedClass ac) {
        XmlRootElement elem = this.findRootElementAnnotation(ac);
        if (elem != null) {
            String name = elem.name();
            return MARKER_FOR_DEFAULT.equals(name) ? "" : name;
        }
        return null;
    }

    public boolean isIgnorableMethod(AnnotatedMethod m) {
        return m.getAnnotation(XmlTransient.class) != null;
    }

    public boolean isIgnorableConstructor(AnnotatedConstructor c) {
        return false;
    }

    public boolean isIgnorableField(AnnotatedField f) {
        return f.getAnnotation(XmlTransient.class) != null;
    }

    public JsonSerializer<?> findSerializer(Annotated am) {
        XmlAdapter<Object, Object> adapter = this.findAdapter(am);
        if (adapter != null) {
            return new XmlAdapterJsonSerializer(adapter);
        }
        Class type = am.getType();
        if (type != null && this._dataHandlerSerializer != null && this.isDataHandler(type)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class<?> type) {
        return type != null && !Object.class.equals(type) && ("javax.activation.DataHandler".equals(type.getName()) || this.isDataHandler(type.getSuperclass()));
    }

    public Class<?> findSerializationType(Annotated a) {
        return null;
    }

    public JsonSerialize.Inclusion findSerializationInclusion(Annotated a, JsonSerialize.Inclusion defValue) {
        if (a instanceof AnnotatedField || a instanceof AnnotatedMethod) {
            boolean nillable = a.getAnnotation(XmlElementWrapper.class) != null ? ((XmlElementWrapper)a.getAnnotation(XmlElementWrapper.class)).nillable() : a.getAnnotation(XmlElement.class) != null && ((XmlElement)a.getAnnotation(XmlElement.class)).nillable();
            return nillable ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
        }
        return JsonSerialize.Inclusion.NON_NULL;
    }

    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        return null;
    }

    public Boolean findGetterAutoDetection(AnnotatedClass ac) {
        XmlAccessType at = this.findAccessType((Annotated)ac);
        if (at != null) {
            boolean enabled = at == XmlAccessType.PUBLIC_MEMBER || at == XmlAccessType.PROPERTY;
            return enabled ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public Boolean findIsGetterAutoDetection(AnnotatedClass ac) {
        return this.findGetterAutoDetection(ac);
    }

    public String findGettablePropertyName(AnnotatedMethod am) {
        if (this.isInvisible(am)) {
            System.err.println("DEBUG: findGettable for " + am + ", invis: " + this.isInvisible(am));
            return null;
        }
        return this.findJaxbSpecifiedPropertyName(am);
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        return false;
    }

    public String findEnumValue(Enum<?> e) {
        Class<?> enumClass = e.getDeclaringClass();
        String enumValue = e.name();
        try {
            XmlEnumValue xmlEnumValue = enumClass.getDeclaredField(enumValue).getAnnotation(XmlEnumValue.class);
            return xmlEnumValue != null ? xmlEnumValue.value() : enumValue;
        }
        catch (NoSuchFieldException e1) {
            throw new IllegalStateException("Could not locate Enum entry '" + enumValue + "' (Enum class " + enumClass.getName() + ")", e1);
        }
    }

    protected boolean isInvisible(AnnotatedField f) {
        boolean invisible = true;
        for (Annotation annotation : f.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled(annotation)) continue;
            invisible = false;
        }
        if (invisible) {
            XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
            XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, (Annotated)f, true, true, true);
            if (at != null) {
                accessType = at.value();
            }
            invisible = accessType != XmlAccessType.FIELD && (accessType != XmlAccessType.PUBLIC_MEMBER || !Modifier.isPublic(f.getAnnotated().getModifiers()));
        }
        return invisible;
    }

    protected boolean isInvisible(AnnotatedMethod m) {
        boolean invisible = true;
        for (Annotation annotation : m.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled(annotation)) continue;
            invisible = false;
        }
        if (this.isPropertiesAccessible((Annotated)m)) {
            PropertyDescriptor pd = this.findPropertyDescriptor(m);
            invisible = pd == null || pd.getReadMethod() == null || pd.getWriteMethod() == null;
        }
        return invisible;
    }

    public String findSerializablePropertyName(AnnotatedField af) {
        if (this.isInvisible(af)) {
            return null;
        }
        Field field = af.getAnnotated();
        String name = this.findJaxbPropertyName(field, field.getType(), "");
        return name == null ? field.getName() : name;
    }

    public JsonDeserializer<?> findDeserializer(Annotated am) {
        XmlAdapter<Object, Object> adapter = this.findAdapter(am);
        if (adapter != null) {
            return new XmlAdapterJsonDeserializer(adapter);
        }
        Class type = am.getType();
        if (type != null && this._dataHandlerDeserializer != null && this.isDataHandler(type)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    public Class<KeyDeserializer> findKeyDeserializer(Annotated am) {
        return null;
    }

    public Class<JsonDeserializer<?>> findContentDeserializer(Annotated am) {
        return null;
    }

    public Class<?> findDeserializationType(Annotated am) {
        return null;
    }

    public Class<?> findDeserializationKeyType(Annotated am) {
        return null;
    }

    public Class<?> findDeserializationContentType(Annotated am) {
        XmlElement annotation = this.findAnnotation(XmlElement.class, am, false, false, false);
        if (annotation != null && annotation.type() != XmlElement.DEFAULT.class) {
            return annotation.type();
        }
        return null;
    }

    public Boolean findSetterAutoDetection(AnnotatedClass ac) {
        return this.isPropertiesAccessible((Annotated)ac);
    }

    public Boolean findCreatorAutoDetection(AnnotatedClass ac) {
        return null;
    }

    public String findSettablePropertyName(AnnotatedMethod am) {
        if (this.isInvisible(am)) {
            return null;
        }
        return this.findJaxbSpecifiedPropertyName(am);
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return false;
    }

    public boolean hasCreatorAnnotation(Annotated am) {
        return false;
    }

    public String findDeserializablePropertyName(AnnotatedField af) {
        if (this.isInvisible(af)) {
            return null;
        }
        Field field = af.getAnnotated();
        return this.findJaxbPropertyName(field, field.getType(), "");
    }

    public String findPropertyNameForParam(AnnotatedParameter param) {
        return null;
    }

    protected <A extends Annotation> A findAnnotation(Class<A> annotationClass, Annotated annotated, boolean includePackage, boolean includeClass, boolean includeSuperclasses) {
        PropertyDescriptor pd;
        A annotation = null;
        if (annotated instanceof AnnotatedMethod && (pd = this.findPropertyDescriptor((AnnotatedMethod)annotated)) != null) {
            annotation = new AnnotatedProperty(pd).getAnnotation(annotationClass);
        }
        if (annotation == null) {
            annotation = annotated.getAnnotated().getAnnotation(annotationClass);
        }
        if (annotation == null) {
            Class memberClass;
            AnnotatedElement annType = annotated.getAnnotated();
            if (annType instanceof Member) {
                memberClass = ((Member)((Object)annType)).getDeclaringClass();
                if (includeClass) {
                    annotation = memberClass.getAnnotation(annotationClass);
                }
            } else if (annType instanceof Class) {
                memberClass = (Class)annType;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
            if (annotation == null) {
                if (includeSuperclasses) {
                    for (Class superclass = memberClass.getSuperclass(); superclass != null && !superclass.equals(Object.class) && annotation == null; superclass = superclass.getSuperclass()) {
                        annotation = superclass.getAnnotation(annotationClass);
                    }
                }
                if (annotation == null && includePackage) {
                    annotation = memberClass.getPackage().getAnnotation(annotationClass);
                }
            }
        }
        return annotation;
    }

    protected boolean isPropertiesAccessible(Annotated ac) {
        XmlAccessType accessType = this.findAccessType(ac);
        if (accessType == null) {
            accessType = XmlAccessType.PUBLIC_MEMBER;
        }
        return accessType == XmlAccessType.PUBLIC_MEMBER || accessType == XmlAccessType.PROPERTY;
    }

    protected XmlAccessType findAccessType(Annotated ac) {
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, ac, true, true, true);
        return at == null ? null : at.value();
    }

    protected boolean isFieldsAccessible(Annotated ac) {
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, ac, true, true, true);
        if (at != null) {
            accessType = at.value();
        }
        return accessType == XmlAccessType.PUBLIC_MEMBER || accessType == XmlAccessType.FIELD;
    }

    protected PropertyDescriptor findPropertyDescriptor(AnnotatedMethod m) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(m.getDeclaringClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                if (descriptor.getReadMethod() != null && descriptor.getReadMethod().getName().equals(m.getName())) {
                    return descriptor;
                }
                if (descriptor.getWriteMethod() == null || !descriptor.getWriteMethod().getName().equals(m.getName())) continue;
                return descriptor;
            }
        }
        catch (IntrospectionException e) {
            return null;
        }
        return null;
    }

    protected String findJaxbSpecifiedPropertyName(AnnotatedMethod am) {
        PropertyDescriptor pd = this.findPropertyDescriptor(am);
        if (pd != null) {
            return this.findJaxbPropertyName(new AnnotatedProperty(pd), pd.getPropertyType(), "");
        }
        return null;
    }

    protected String findJaxbPropertyName(AnnotatedElement ae, Class<?> aeType, String defaultName) {
        XmlValue valueInfo;
        XmlElementWrapper elementWrapper = ae.getAnnotation(XmlElementWrapper.class);
        if (elementWrapper != null) {
            String name = elementWrapper.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlAttribute attribute = ae.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            String name = attribute.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElement element = ae.getAnnotation(XmlElement.class);
        if (element != null) {
            String name = element.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            return defaultName;
        }
        XmlElementRef elementRef = ae.getAnnotation(XmlElementRef.class);
        if (elementRef != null) {
            String name = elementRef.name();
            if (!MARKER_FOR_DEFAULT.equals(name)) {
                return name;
            }
            XmlRootElement rootElement = aeType.getAnnotation(XmlRootElement.class);
            if (rootElement != null) {
                name = rootElement.name();
                if (!MARKER_FOR_DEFAULT.equals(name)) {
                    return name;
                }
                return Introspector.decapitalize(aeType.getSimpleName());
            }
        }
        if ((valueInfo = ae.getAnnotation(XmlValue.class)) != null) {
            return "value";
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass ac) {
        return this.findAnnotation(XmlRootElement.class, (Annotated)ac, true, false, true);
    }

    protected XmlAdapter<Object, Object> findAdapter(Annotated am) {
        boolean isMember;
        Class<?> potentialAdaptee;
        XmlAdapter adapter = null;
        if (am instanceof AnnotatedClass) {
            potentialAdaptee = ((AnnotatedClass)am).getAnnotated();
            isMember = false;
        } else {
            potentialAdaptee = ((Member)((Object)am.getAnnotated())).getDeclaringClass();
            isMember = true;
        }
        XmlJavaTypeAdapter adapterInfo = potentialAdaptee.getAnnotation(XmlJavaTypeAdapter.class);
        if (adapterInfo != null) {
            try {
                adapter = (XmlAdapter)adapterInfo.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (adapter == null && isMember) {
            XmlJavaTypeAdapters adapters;
            adapterInfo = this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
            if (adapterInfo == null && (adapters = this.findAnnotation(XmlJavaTypeAdapters.class, am, true, false, false)) != null) {
                for (XmlJavaTypeAdapter info : adapters.value()) {
                    if (!info.type().isAssignableFrom(((Member)((Object)am.getAnnotated())).getDeclaringClass())) continue;
                    adapterInfo = info;
                    break;
                }
            }
            if (adapterInfo != null) {
                try {
                    adapter = (XmlAdapter)adapterInfo.value().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return adapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedProperty
    implements AnnotatedElement {
        private final PropertyDescriptor pd;

        private AnnotatedProperty(PropertyDescriptor pd) {
            this.pd = pd;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.pd.getReadMethod() != null && this.pd.getReadMethod().isAnnotationPresent(annotationClass) || this.pd.getWriteMethod() != null && this.pd.getWriteMethod().isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            Object ann;
            Object v0 = ann = this.pd.getReadMethod() != null ? this.pd.getReadMethod().getAnnotation(annotationClass) : null;
            if (ann == null) {
                ann = this.pd.getWriteMethod() != null ? this.pd.getWriteMethod().getAnnotation(annotationClass) : null;
            }
            return ann;
        }

        @Override
        public Annotation[] getAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            throw new UnsupportedOperationException();
        }
    }
}

