/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseNodeDeserializer<N extends JsonNode>
extends StdDeserializer<N> {
    protected JsonNodeFactory _nodeFactory = JsonNodeFactory.instance;

    public BaseNodeDeserializer(Class<N> nodeClass) {
        super(nodeClass);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public void setNodeFactory(JsonNodeFactory nf) {
        this._nodeFactory = nf;
    }

    protected void _reportProblem(JsonParser jp, String msg) throws JsonMappingException {
        throw new JsonMappingException(msg, jp.getTokenLocation());
    }

    protected void _handleDuplicateField(String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
    }

    protected final ObjectNode deserializeObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = this._nodeFactory.objectNode();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            JsonNode value = (JsonNode)this.deserialize(jp, ctxt);
            JsonNode old = node.put(fieldName, value);
            if (old == null) continue;
            this._handleDuplicateField(fieldName, node, old, value);
        }
        return node;
    }

    protected final ArrayNode deserializeArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ArrayNode node = this._nodeFactory.arrayNode();
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            node.add((JsonNode)this.deserialize(jp, ctxt));
        }
        return node;
    }
}

