/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.HashMap;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.deser.DateDeserializer;
import org.codehaus.jackson.map.deser.FromStringDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.map.deser.UntypedObjectDeserializer;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StdDeserializers {
    final HashMap<JavaType, JsonDeserializer<Object>> _deserializers = new HashMap();

    private StdDeserializers() {
        this.add(new UntypedObjectDeserializer());
        this.add(new StdDeserializer.StringDeserializer());
        this.add(new StdDeserializer.ClassDeserializer());
        this.add(new StdDeserializer.BooleanDeserializer(Boolean.class, null));
        this.add(new StdDeserializer.ByteDeserializer(Byte.class, null));
        this.add(new StdDeserializer.ShortDeserializer(Short.class, null));
        this.add(new StdDeserializer.CharacterDeserializer(Character.class, null));
        this.add(new StdDeserializer.IntegerDeserializer(Integer.class, null));
        this.add(new StdDeserializer.LongDeserializer(Long.class, null));
        this.add(new StdDeserializer.FloatDeserializer(Float.class, null));
        this.add(new StdDeserializer.DoubleDeserializer(Double.class, null));
        this.add(new StdDeserializer.BooleanDeserializer(Boolean.TYPE, Boolean.FALSE));
        this.add(new StdDeserializer.ByteDeserializer(Byte.TYPE, (byte)0));
        this.add(new StdDeserializer.ShortDeserializer(Short.TYPE, (short)0));
        this.add(new StdDeserializer.CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000')));
        this.add(new StdDeserializer.IntegerDeserializer(Integer.TYPE, 0));
        this.add(new StdDeserializer.LongDeserializer(Long.TYPE, 0L));
        this.add(new StdDeserializer.FloatDeserializer(Float.TYPE, Float.valueOf(0.0f)));
        this.add(new StdDeserializer.DoubleDeserializer(Double.TYPE, 0.0));
        this.add(new StdDeserializer.NumberDeserializer());
        this.add(new StdDeserializer.BigDecimalDeserializer());
        this.add(new StdDeserializer.BigIntegerDeserializer());
        this.add(new DateDeserializer());
        this.add(new StdDeserializer.SqlDateDeserializer());
        this.add(new StdDeserializer.CalendarDeserializer());
        this.add(new FromStringDeserializer.UUIDDeserializer());
        this.add(new FromStringDeserializer.URLDeserializer());
        this.add(new FromStringDeserializer.URIDeserializer());
        this.add(new StdDeserializer.StackTraceElementDeserializer());
    }

    private HashMap<JavaType, JsonDeserializer<Object>> getDeserializers() {
        return this._deserializers;
    }

    public static HashMap<JavaType, JsonDeserializer<Object>> constructAll() {
        return new StdDeserializers().getDeserializers();
    }

    void add(StdDeserializer<?> stdDeser) {
        this.add(stdDeser, stdDeser.getValueClass());
    }

    void add(StdDeserializer<?> stdDeser, Class<?> ... valueClasses) {
        StdDeserializer<?> deser = stdDeser;
        for (Class<?> valueClass : valueClasses) {
            this._deserializers.put(TypeFactory.fromClass(valueClass), deser);
        }
    }
}

