/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory {
    public static final TypeFactory instance = new TypeFactory();
    protected final HashMap<String, JavaType> _commonTypeCache = new HashMap();

    protected TypeFactory() {
        SimpleType.addCommonTypes(this._commonTypeCache);
        ArrayType.addCommonTypes(this._commonTypeCache);
    }

    public static JavaType fromClass(Class<?> clz) {
        return instance._fromClass(clz);
    }

    public static JavaType fromTypeReference(TypeReference<?> ref) {
        return TypeFactory.fromType(ref.getType());
    }

    public static JavaType fromType(Type type) {
        return instance._fromType(type);
    }

    protected JavaType _fromClass(Class<?> clz) {
        String clzName = clz.getName();
        JavaType type = this._commonTypeCache.get(clzName);
        if (type != null) {
            return type;
        }
        if (clz.isArray()) {
            return ArrayType.construct(TypeFactory.fromClass(clz.getComponentType()));
        }
        if (Map.class.isAssignableFrom(clz)) {
            JavaType unknownType = TypeFactory.fromClass(Object.class);
            return MapType.untyped(clz, unknownType, unknownType);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            JavaType unknownType = TypeFactory.fromClass(Object.class);
            return CollectionType.untyped(clz, unknownType);
        }
        return SimpleType.construct(clz);
    }

    public JavaType _fromType(Type type) {
        if (type instanceof Class) {
            return this._fromClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this._fromParamType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this._fromArrayType((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return this._fromVariable((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return this._fromWildcard((WildcardType)type);
        }
        throw new IllegalArgumentException("Unrecognized Type: " + type.toString());
    }

    protected JavaType _fromParamType(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        if (Map.class.isAssignableFrom(rawType)) {
            Type[] args = type.getActualTypeArguments();
            return MapType.typed(rawType, TypeFactory.fromType(args[0]), TypeFactory.fromType(args[1]));
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return CollectionType.typed(rawType, TypeFactory.fromType(type.getActualTypeArguments()[0]));
        }
        return this._fromClass(rawType);
    }

    protected JavaType _fromArrayType(GenericArrayType type) {
        JavaType compType = this._fromType(type.getGenericComponentType());
        return ArrayType.construct(compType);
    }

    protected JavaType _fromVariable(TypeVariable<?> type) {
        return this._fromType(type.getBounds()[0]);
    }

    protected JavaType _fromWildcard(WildcardType type) {
        return this._fromType(type.getUpperBounds()[0]);
    }
}

