/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.ClassIntrospector;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory();

    protected BeanDeserializerFactory() {
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(JavaType type, DeserializerProvider p) throws JsonMappingException {
        JsonDeserializer<Object> deser = super.createBeanDeserializer(type, p);
        if (deser != null) {
            return deser;
        }
        Class beanClass = type.getRawClass();
        if (!this.isPotentialBeanType(beanClass)) {
            return null;
        }
        ClassIntrospector intr = ClassIntrospector.forDeserialization(beanClass);
        JsonDeserializer<Object> ad = this.findDeserializerFromAnnotation(intr.getClassInfo());
        if (ad != null) {
            return ad;
        }
        if (!ClassUtil.isConcrete(beanClass)) {
            return null;
        }
        BeanDeserializer.StringConstructor sctor = this.getStringCreators(beanClass, intr);
        BeanDeserializer.NumberConstructor nctor = this.getNumberCreators(beanClass, intr);
        Constructor<?> defaultCtor = intr.findDefaultConstructor();
        if (sctor == null && nctor == null && defaultCtor == null) {
            throw new IllegalArgumentException("Can not create Bean deserializer for (" + type + "): neither default constructor nor factory methods found");
        }
        BeanDeserializer bd = new BeanDeserializer(type, defaultCtor, sctor, nctor);
        this.addBeanProps(intr, bd);
        return bd;
    }

    protected void addBeanProps(ClassIntrospector intr, BeanDeserializer deser) throws JsonMappingException {
        Class<?> beanClass = deser.getBeanClass();
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = intr.findSetters();
        AnnotatedMethod anyM = intr.findAnySetter();
        if (anyM != null) {
            deser.setAnySetter(this.constructAnySetter(anyM));
        }
        for (Map.Entry<String, AnnotatedMethod> en : methodsByProp.entrySet()) {
            SettableBeanProperty oldP;
            SettableBeanProperty prop;
            String name = en.getKey();
            AnnotatedMethod am = en.getValue();
            am.fixAccess();
            Type rawType = am.getGenericParameterTypes()[0];
            JavaType type = TypeFactory.fromType(rawType);
            JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(am);
            Method m = am.getAnnotated();
            if (propDeser != null) {
                prop = new SettableBeanProperty(name, type, m);
                prop.setValueDeserializer(propDeser);
            } else {
                type = this.modifyTypeByAnnotation(am, type);
                prop = new SettableBeanProperty(name, type, m);
            }
            if ((oldP = deser.addSetter(prop)) == null) continue;
            throw new IllegalArgumentException("Duplicate property '" + name + "' for class " + beanClass.getName());
        }
    }

    protected SettableAnyProperty constructAnySetter(AnnotatedMethod am) throws JsonMappingException {
        am.fixAccess();
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(am);
        Type rawType = am.getGenericParameterTypes()[1];
        JavaType type = TypeFactory.fromType(rawType);
        Method m = am.getAnnotated();
        if (deser != null) {
            SettableAnyProperty prop = new SettableAnyProperty(type, m);
            prop.setValueDeserializer(deser);
            return prop;
        }
        type = this.modifyTypeByAnnotation(am, type);
        return new SettableAnyProperty(type, m);
    }

    BeanDeserializer.StringConstructor getStringCreators(Class<?> beanClass, ClassIntrospector intr) {
        Constructor<?> sctor = intr.findSingleArgConstructor(String.class);
        Method factoryMethod = intr.findFactoryMethod(String.class);
        return new BeanDeserializer.StringConstructor(beanClass, sctor, factoryMethod);
    }

    BeanDeserializer.NumberConstructor getNumberCreators(Class<?> beanClass, ClassIntrospector intr) {
        Constructor<?> intCtor = intr.findSingleArgConstructor(Integer.TYPE, Integer.class);
        Constructor<?> longCtor = intr.findSingleArgConstructor(Long.TYPE, Long.class);
        Method intFactoryMethod = intr.findFactoryMethod(Integer.TYPE, Integer.class);
        Method longFactoryMethod = intr.findFactoryMethod(Long.TYPE, Long.class);
        return new BeanDeserializer.NumberConstructor(beanClass, intCtor, longCtor, intFactoryMethod, longFactoryMethod);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }
}

