/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public final class ContainerSerializers {
    private ContainerSerializers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumMapSerializer
    extends JsonSerializer<EnumMap<? extends Enum<?>, ?>> {
        @Override
        public void serialize(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            for (Map.Entry<Enum<?>, ?> entry : value.entrySet()) {
                JsonSerializer<Object> currSerializer;
                jgen.writeFieldName(entry.getKey().name());
                Object valueElem = entry.getValue();
                if (valueElem == null) {
                    provider.getNullValueSerializer().serialize(null, jgen, provider);
                    continue;
                }
                Class<?> cc = valueElem.getClass();
                if (cc == prevClass) {
                    currSerializer = prevSerializer;
                } else {
                    prevSerializer = currSerializer = provider.findValueSerializer(cc);
                    prevClass = cc;
                }
                try {
                    currSerializer.serialize(valueElem, jgen, provider);
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, value, entry.getKey().name());
                }
            }
            jgen.writeEndObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MapSerializer
    extends JsonSerializer<Map<?, ?>> {
        public static final MapSerializer instance = new MapSerializer();

        @Override
        public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            if (!value.isEmpty()) {
                JsonSerializer<Object> keySerializer = provider.getKeySerializer();
                JsonSerializer<Object> prevValueSerializer = null;
                Class<?> prevValueClass = null;
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    JsonSerializer<Object> currSerializer;
                    Object keyElem = entry.getKey();
                    if (keyElem == null) {
                        provider.getNullKeySerializer().serialize(null, jgen, provider);
                    } else {
                        keySerializer.serialize(keyElem, jgen, provider);
                    }
                    Object valueElem = entry.getValue();
                    if (valueElem == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = valueElem.getClass();
                    if (cc == prevValueClass) {
                        currSerializer = prevValueSerializer;
                    } else {
                        prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevValueClass = cc;
                    }
                    try {
                        currSerializer.serialize(valueElem, jgen, provider);
                    }
                    catch (Exception e) {
                        String keyDesc = "" + keyElem;
                        throw JsonMappingException.wrapWithPath((Throwable)e, value, keyDesc);
                    }
                }
            }
            jgen.writeEndObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumSetSerializer
    extends JsonSerializer<EnumSet<? extends Enum<?>>> {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            for (Enum enum_ : value) {
                jgen.writeString(enum_.name());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IterableSerializer
    extends JsonSerializer<Iterable<?>> {
        public static final IterableSerializer instance = new IterableSerializer();

        @Override
        public void serialize(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (it.hasNext());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IteratorSerializer
    extends JsonSerializer<Iterator<?>> {
        public static final IteratorSerializer instance = new IteratorSerializer();

        @Override
        public void serialize(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            if (value.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = value.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (value.hasNext());
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CollectionSerializer
    extends JsonSerializer<Collection<?>> {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                int i = 0;
                try {
                    do {
                        Object elem;
                        if ((elem = it.next()) == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                        } else {
                            JsonSerializer<Object> currSerializer;
                            Class<?> cc = elem.getClass();
                            if (cc == prevClass) {
                                currSerializer = prevSerializer;
                            } else {
                                prevSerializer = currSerializer = provider.findValueSerializer(cc);
                                prevClass = cc;
                            }
                            currSerializer.serialize(elem, jgen, provider);
                        }
                        ++i;
                    } while (it.hasNext());
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, value, i);
                }
            }
            jgen.writeEndArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IndexedListSerializer
    extends JsonSerializer<List<?>> {
        public static final IndexedListSerializer instance = new IndexedListSerializer();

        @Override
        public void serialize(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.size();
            if (len > 0) {
                int i;
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                try {
                    for (i = 0; i < len; ++i) {
                        JsonSerializer<Object> currSerializer;
                        Object elem = value.get(i);
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                            continue;
                        }
                        Class<?> cc = elem.getClass();
                        if (cc == prevClass) {
                            currSerializer = prevSerializer;
                        } else {
                            prevSerializer = currSerializer = provider.findValueSerializer(cc);
                            prevClass = cc;
                        }
                        currSerializer.serialize(elem, jgen, provider);
                    }
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, value, i);
                }
            }
            jgen.writeEndArray();
        }
    }
}

