/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ContainerNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.MissingNode;
import org.codehaus.jackson.node.TextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectNode
extends ContainerNode {
    LinkedHashMap<String, JsonNode> _children = null;

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    public boolean isObject() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    public Iterator<JsonNode> getElements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.values().iterator();
    }

    @Override
    public JsonNode get(int index) {
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        if (this._children != null) {
            return this._children.get(fieldName);
        }
        return null;
    }

    public Iterator<String> getFieldNames() {
        return this._children == null ? ContainerNode.NoStringsIterator.instance() : this._children.keySet().iterator();
    }

    public JsonNode path(int index) {
        return MissingNode.getInstance();
    }

    public JsonNode path(String fieldName) {
        JsonNode n;
        if (this._children != null && (n = this._children.get(fieldName)) != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeStartObject();
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                jg.writeFieldName(en.getKey());
                en.getValue().writeTo(jg);
            }
        }
        jg.writeEndObject();
    }

    public Iterator<Map.Entry<String, JsonNode>> getFields() {
        if (this._children == null) {
            return NoFieldsIterator.instance;
        }
        return this._children.entrySet().iterator();
    }

    public JsonNode put(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._put(fieldName, value);
    }

    public JsonNode remove(String fieldName) {
        if (this._children != null) {
            return (JsonNode)this._children.remove(fieldName);
        }
        return null;
    }

    public ArrayNode putArray(String fieldName) {
        ArrayNode n = this.arrayNode();
        this._put(fieldName, n);
        return n;
    }

    public ObjectNode putObject(String fieldName) {
        ObjectNode n = this.objectNode();
        this._put(fieldName, n);
        return n;
    }

    public void put(String fieldName, int v) {
        this._put(fieldName, this.numberNode(v));
    }

    public void put(String fieldName, long v) {
        this._put(fieldName, this.numberNode(v));
    }

    public void put(String fieldName, float v) {
        this._put(fieldName, this.numberNode(v));
    }

    public void put(String fieldName, double v) {
        this._put(fieldName, this.numberNode(v));
    }

    public void put(String fieldName, BigDecimal v) {
        this._put(fieldName, this.numberNode(v));
    }

    public void put(String fieldName, String v) {
        this._put(fieldName, this.textNode(v));
    }

    public void put(String fieldName, boolean v) {
        this._put(fieldName, this.booleanNode(v));
    }

    public void put(String fieldName, byte[] v) {
        this._put(fieldName, this.binaryNode(v));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        if (other.size() != this.size()) {
            return false;
        }
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                String key = en.getKey();
                JsonNode value = en.getValue();
                JsonNode otherValue = other.get(key);
                if (otherValue != null && otherValue.equals((Object)value)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this._children == null ? -1 : this._children.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 + (this.size() << 4));
        sb.append("{");
        if (this._children != null) {
            int count = 0;
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                if (count > 0) {
                    sb.append(",");
                }
                ++count;
                TextNode.appendQuoted(sb, en.getKey());
                sb.append(':');
                sb.append(en.getValue().toString());
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private final JsonNode _put(String fieldName, JsonNode value) {
        if (this._children == null) {
            this._children = new LinkedHashMap();
        }
        return this._children.put(fieldName, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NoFieldsIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        static final NoFieldsIterator instance = new NoFieldsIterator();

        private NoFieldsIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, JsonNode> next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

