/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.node.ValueNode;

public final class BooleanNode
extends ValueNode {
    private static final BooleanNode sTrue = new BooleanNode();
    private static final BooleanNode sFalse = new BooleanNode();

    private BooleanNode() {
    }

    public static BooleanNode getTrue() {
        return sTrue;
    }

    public static BooleanNode getFalse() {
        return sFalse;
    }

    public static BooleanNode valueOf(boolean b) {
        return b ? sTrue : sFalse;
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean getBooleanValue() {
        return this == sTrue;
    }

    public String getValueAsText() {
        return this == sTrue ? "true" : "false";
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeBoolean(this == sTrue);
    }

    public boolean equals(Object o) {
        return o == this;
    }
}

