/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonGetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonSetter;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIntrospector {
    transient Constructor<?> _defaultConstructor;
    transient List<Constructor<?>> _nonDefaultConstructors;
    transient Method[] _directMethods;
    protected final Class<?> _class;

    public ClassIntrospector(Class<?> c) {
        this._class = c;
    }

    public LinkedHashMap<String, Method> findGetters() {
        Method m;
        LinkedHashMap<String, Method> results = new LinkedHashMap<String, Method>();
        HashSet<String> maskedMethods = new HashSet<String>();
        DeclMethodIter it = this.methodIterator();
        while ((m = it.next()) != null) {
            Method old;
            String propName;
            String name;
            if (!this.okSignatureForGetter(m) || !maskedMethods.add(name = m.getName()) || m.isAnnotationPresent(JsonIgnore.class)) continue;
            JsonGetter ann = m.getAnnotation(JsonGetter.class);
            if (ann != null) {
                propName = ann.value();
                if (propName == null || propName.length() == 0) {
                    propName = m.getName();
                }
            } else {
                propName = this.okNameForGetter(m);
                if (propName == null) continue;
            }
            if ((old = results.put(propName, m)) == null) continue;
            String oldDesc = old.getDeclaringClass().getName() + "#" + old.getName();
            String newDesc = m.getDeclaringClass().getName() + "#" + m.getName();
            throw new IllegalArgumentException("Conflicting getter definitions for property \"" + propName + "\": " + oldDesc + "() vs " + newDesc + "()");
        }
        return results;
    }

    public LinkedHashMap<String, Method> findSetters() {
        Method m;
        LinkedHashMap<String, Method> results = new LinkedHashMap<String, Method>();
        HashSet<String> maskedMethods = new HashSet<String>();
        DeclMethodIter it = this.methodIterator();
        while ((m = it.next()) != null) {
            Method old;
            String propName;
            String name;
            if (!this.okSignatureForSetter(m) || !maskedMethods.add(name = m.getName()) || m.isAnnotationPresent(JsonIgnore.class)) continue;
            JsonSetter ann = m.getAnnotation(JsonSetter.class);
            if (ann != null) {
                propName = ann.value();
                if (propName == null || propName.length() == 0) {
                    propName = m.getName();
                }
            } else {
                propName = this.okNameForSetter(m);
                if (propName == null) continue;
            }
            if ((old = results.put(propName, m)) == null) continue;
            String oldDesc = old.getDeclaringClass().getName() + "#" + old.getName();
            String newDesc = m.getDeclaringClass().getName() + "#" + m.getName();
            throw new IllegalArgumentException("Conflicting setter definitions for property \"" + propName + "\": " + oldDesc + "() vs " + newDesc + "()");
        }
        return results;
    }

    public Constructor<?> findDefaultConstructor() {
        if (this._nonDefaultConstructors == null) {
            this._fetchConstructors();
        }
        return this._defaultConstructor;
    }

    public Constructor<?> findSingleArgConstructor(Class<?> ... argTypes) {
        if (this._nonDefaultConstructors == null) {
            this._fetchConstructors();
        }
        for (Constructor<?> c : this._nonDefaultConstructors) {
            Class<?>[] args = c.getParameterTypes();
            if (args.length != 1) continue;
            Class<?> actArg = args[0];
            for (Class<?> expArg : argTypes) {
                if (expArg != actArg) continue;
                ClassUtil.checkAndFixAccess(c, this._class);
                return c;
            }
        }
        return null;
    }

    public List<Method> findStaticSingleArgMethods() {
        ArrayList<Method> result = null;
        for (Method m : this.declaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || m.isAnnotationPresent(JsonIgnore.class) || m.getParameterTypes().length != 1) continue;
            if (result == null) {
                result = new ArrayList<Method>();
            }
            result.add(m);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Method findFactoryMethod(Class<?> ... expArgTypes) {
        for (Method m : this.findStaticSingleArgMethods()) {
            if (m.getReturnType() != this._class || !m.isAnnotationPresent(JsonCreator.class) && (!"valueOf".equals(m.getName()) || !Modifier.isPublic(m.getModifiers()))) continue;
            Class<?> actualArgType = m.getParameterTypes()[0];
            for (Class<?> expArgType : expArgTypes) {
                if (!actualArgType.isAssignableFrom(expArgType)) continue;
                ClassUtil.checkAndFixAccess(m, this._class);
                return m;
            }
        }
        return null;
    }

    protected boolean okSignatureForGetter(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m.getParameterTypes();
        if (pts != null && pts.length > 0) {
            return false;
        }
        Class<?> rt = m.getReturnType();
        return rt != Void.TYPE;
    }

    protected String okNameForGetter(Method m) {
        String name = m.getName();
        if (!Modifier.isPublic(m.getModifiers())) {
            return null;
        }
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) && this.isCglibGetCallbacks(m)) {
                return null;
            }
            return this.mangleGetterName(m, name.substring(3));
        }
        if (name.startsWith("is")) {
            Class<?> rt = m.getReturnType();
            if (rt != Boolean.class && rt != Boolean.TYPE) {
                return null;
            }
            return this.mangleGetterName(m, name.substring(2));
        }
        return null;
    }

    protected String mangleGetterName(Method method, String basename) {
        return ClassUtil.manglePropertyName(basename);
    }

    protected boolean isCglibGetCallbacks(Method m) {
        Class<?> rt = m.getReturnType();
        if (rt == null || !rt.isArray()) {
            return false;
        }
        Class<?> compType = rt.getComponentType();
        Package pkg = compType.getPackage();
        return pkg != null && pkg.getName().startsWith("net.sf.cglib");
    }

    protected boolean okSignatureForSetter(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m.getParameterTypes();
        return pts != null && pts.length == 1;
    }

    protected String okNameForSetter(Method m) {
        String name = m.getName();
        if (name.startsWith("set")) {
            if ((name = this.mangleSetterName(m, name.substring(3))) == null) {
                return null;
            }
            return name;
        }
        return null;
    }

    protected String mangleSetterName(Method method, String basename) {
        return ClassUtil.manglePropertyName(basename);
    }

    protected Method[] declaredMethods() {
        if (this._directMethods == null) {
            this._directMethods = this._class.getDeclaredMethods();
        }
        return this._directMethods;
    }

    protected DeclMethodIter methodIterator() {
        return new DeclMethodIter(this._class, this.declaredMethods());
    }

    protected void _fetchConstructors() {
        ArrayList publicCtors = null;
        for (Constructor<?> ctor : this._class.getDeclaredConstructors()) {
            if (ctor.isVarArgs() || ctor.isAnnotationPresent(JsonIgnore.class)) continue;
            if (ctor.getParameterTypes().length == 0) {
                ClassUtil.checkAndFixAccess(ctor, this._class);
                this._defaultConstructor = ctor;
                continue;
            }
            if (!Modifier.isPublic(ctor.getModifiers()) && !ctor.isAnnotationPresent(JsonCreator.class)) continue;
            if (publicCtors == null) {
                publicCtors = new ArrayList();
            }
            publicCtors.add(ctor);
        }
        this._nonDefaultConstructors = publicCtors == null ? Collections.emptyList() : publicCtors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeclMethodIter {
        Class<?> _currClass;
        Method[] _currMethods;
        int _currIndex;

        public DeclMethodIter(Class<?> c, Method[] declMethods) {
            this._currClass = c;
            this._currMethods = declMethods;
            this._currIndex = 0;
        }

        public Method next() {
            while (this._currIndex >= this._currMethods.length) {
                if (this._currClass == null) {
                    return null;
                }
                this._currClass = this._currClass.getSuperclass();
                if (this._currClass == null || this._currClass == Object.class) {
                    return null;
                }
                this._currIndex = 0;
                this._currMethods = this._currClass.getDeclaredMethods();
            }
            return this._currMethods[this._currIndex++];
        }
    }
}

