/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonUseDeserializer;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.type.ClassIntrospector;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory();

    protected BeanDeserializerFactory() {
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(JavaType type, DeserializerProvider p) throws JsonMappingException {
        Class<?> beanClass = type.getRawClass();
        if (!this.isPotentialBeanType(beanClass)) {
            return null;
        }
        JsonDeserializer<Object> ad = this.findDeserializerByAnnotation(beanClass);
        if (ad != null) {
            return ad;
        }
        ClassIntrospector intr = new ClassIntrospector(beanClass);
        BeanDeserializer.StringConstructor sctor = this.getStringCreators(beanClass, intr);
        BeanDeserializer.NumberConstructor nctor = this.getNumberCreators(beanClass, intr);
        Constructor<?> defaultCtor = intr.findDefaultConstructor();
        if (sctor == null && nctor == null && defaultCtor == null) {
            throw new IllegalArgumentException("Can not create Bean deserializer for (" + type + "): neither default constructor nor factory methods found");
        }
        BeanDeserializer deser = new BeanDeserializer(type, defaultCtor, sctor, nctor);
        this.addBeanProps(intr, deser);
        return deser;
    }

    protected void addBeanProps(ClassIntrospector intr, BeanDeserializer deser) throws JsonMappingException {
        Class<?> beanClass = deser.getBeanClass();
        LinkedHashMap<String, Method> methodsByProp = intr.findSetters();
        for (Map.Entry<String, Method> en : methodsByProp.entrySet()) {
            SettableBeanProperty oldP;
            SettableBeanProperty prop;
            String name = en.getKey();
            Method m = en.getValue();
            ClassUtil.checkAndFixAccess(m, m.getDeclaringClass());
            Type rawType = m.getGenericParameterTypes()[0];
            JavaType type = TypeFactory.instance.fromType(rawType);
            JsonDeserializer<Object> propDeser = this.findDeserializerByAnnotation(m);
            if (propDeser != null) {
                prop = new SettableBeanProperty(name, type, m);
                prop.setValueDeserializer(propDeser);
            } else {
                type = this.modifyTypeByAnnotation(m, type);
                prop = new SettableBeanProperty(name, type, m);
            }
            if ((oldP = deser.addSetter(prop)) == null) continue;
            throw new IllegalArgumentException("Duplicate property '" + name + "' for class " + beanClass.getName());
        }
    }

    protected JsonDeserializer<Object> findDeserializerByAnnotation(AnnotatedElement elem) {
        JsonUseDeserializer ann = elem.getAnnotation(JsonUseDeserializer.class);
        if (ann != null) {
            Class deserClass = ann.value();
            if (!JsonDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalArgumentException("Invalid @JsonDeserializer annotation for " + ClassUtil.descFor(elem) + ": value (" + deserClass.getName() + ") does not implement JsonDeserializer interface");
            }
            try {
                Object ob = deserClass.newInstance();
                JsonDeserializer ser = (JsonDeserializer)ob;
                return ser;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + deserClass.getName() + " to use as deserializer for " + ClassUtil.descFor(elem) + ", problem: " + e.getMessage(), e);
            }
        }
        return null;
    }

    BeanDeserializer.StringConstructor getStringCreators(Class<?> beanClass, ClassIntrospector intr) {
        Constructor<?> sctor = intr.findSingleArgConstructor(String.class);
        Method factoryMethod = intr.findFactoryMethod(String.class);
        return new BeanDeserializer.StringConstructor(beanClass, sctor, factoryMethod);
    }

    BeanDeserializer.NumberConstructor getNumberCreators(Class<?> beanClass, ClassIntrospector intr) {
        Constructor<?> intCtor = intr.findSingleArgConstructor(Integer.TYPE, Integer.class);
        Constructor<?> longCtor = intr.findSingleArgConstructor(Long.TYPE, Long.class);
        Method intFactoryMethod = intr.findFactoryMethod(Integer.TYPE, Integer.class);
        Method longFactoryMethod = intr.findFactoryMethod(Long.TYPE, Long.class);
        return new BeanDeserializer.NumberConstructor(beanClass, intCtor, longCtor, intFactoryMethod, longFactoryMethod);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }
}

