/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.jackson.annotate.JsonClass;
import org.codehaus.jackson.annotate.JsonContentClass;
import org.codehaus.jackson.annotate.JsonKeyClass;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializers;
import org.codehaus.jackson.map.deser.CollectionDeserializer;
import org.codehaus.jackson.map.deser.EnumDeserializer;
import org.codehaus.jackson.map.deser.EnumMapDeserializer;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.EnumSetDeserializer;
import org.codehaus.jackson.map.deser.MapDeserializer;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicDeserializerFactory
extends DeserializerFactory {
    static final JavaType _typeString = TypeFactory.instance.fromClass(String.class);
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers;

    protected BasicDeserializerFactory() {
    }

    public JsonDeserializer<Object> createArrayDeserializer(ArrayType type, DeserializerProvider p) throws JsonMappingException {
        JavaType elemType = type.getComponentType();
        JsonDeserializer<Object> deser = _arrayDeserializers.get(elemType);
        if (deser != null) {
            return deser;
        }
        if (elemType.isPrimitive()) {
            throw new IllegalArgumentException("Internal error: primitive type (" + type + ") passed, no array deserializer found");
        }
        JsonDeserializer<Object> valueDes = p.findValueDeserializer(elemType, type, null);
        return new ArrayDeserializer(type, valueDes);
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(CollectionType type, DeserializerProvider p) throws JsonMappingException {
        JavaType valueType = type.getElementType();
        Class<Object> collectionClass = type.getRawClass();
        if (EnumSet.class.isAssignableFrom(collectionClass)) {
            return new EnumSetDeserializer(EnumResolver.constructFor(valueType.getRawClass()));
        }
        JsonDeserializer<Object> valueDes = p.findValueDeserializer(valueType, type, null);
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        return new CollectionDeserializer(collectionClass, valueDes);
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(MapType type, DeserializerProvider p) throws JsonMappingException {
        KeyDeserializer keyDes;
        JavaType keyType = type.getKeyType();
        JavaType valueType = type.getValueType();
        JsonDeserializer<Object> valueDes = p.findValueDeserializer(valueType, type, null);
        Class<Object> mapClass = type.getRawClass();
        if (EnumMap.class.isAssignableFrom(mapClass)) {
            return new EnumMapDeserializer(EnumResolver.constructFor(keyType.getRawClass()), valueDes);
        }
        KeyDeserializer keyDeserializer = keyDes = _typeString.equals(keyType) ? null : p.findKeyDeserializer(keyType);
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + type);
            }
            mapClass = fallback;
        }
        return new MapDeserializer(mapClass, keyDes, valueDes);
    }

    public JsonDeserializer<Object> createEnumDeserializer(SimpleType type, DeserializerProvider p) {
        EnumDeserializer des;
        EnumDeserializer result = des = new EnumDeserializer(EnumResolver.constructFor(type.getRawClass()));
        return result;
    }

    public abstract JsonDeserializer<Object> createBeanDeserializer(JavaType var1, DeserializerProvider var2) throws JsonMappingException;

    protected JavaType modifyTypeByAnnotation(Method m, JavaType type) throws JsonMappingException {
        JsonContentClass contentAnn;
        JsonKeyClass keyAnn;
        JsonClass mainAnn = m.getAnnotation(JsonClass.class);
        if (mainAnn != null) {
            Class subclass = mainAnn.value();
            try {
                type = type.narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type + " with @JsonClass(" + subclass.getName() + "): " + iae.getMessage(), null, iae);
            }
        }
        if ((keyAnn = m.getAnnotation(JsonKeyClass.class)) != null) {
            if (!(type instanceof MapType)) {
                throw new JsonMappingException("Illegal @JsonKey annotation: type " + type + " is not a Map type");
            }
            Class keyClass = keyAnn.value();
            try {
                type = ((MapType)type).narrowKey(keyClass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow key of " + type + " with @JsonKeyClass(" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
            }
        }
        if ((contentAnn = m.getAnnotation(JsonContentClass.class)) != null) {
            if (!type.isContainerType()) {
                throw new JsonMappingException("Illegal @JsonContentClass annotation on " + ClassUtil.descFor(m) + "; can only be used for container types (Collections, Maps, arrays");
            }
            Class cc = contentAnn.value();
            try {
                type = type.narrowContentsBy(cc);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow content type " + type + " with @JsonContentClass(" + cc.getName() + "): " + iae.getMessage(), null, iae);
            }
        }
        return type;
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> value;
            Class<?> key = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> mapValue = value = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(key.getName(), mapValue);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
        _arrayDeserializers = ArrayDeserializers.getAll();
    }
}

