/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import java.lang.reflect.Array;
import java.util.Map;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayType
extends JavaType {
    final JavaType _componentType;
    final boolean _fullyTyped;
    final Object _emptyArray;

    private ArrayType(JavaType componentType, Object emptyInstance) {
        super(emptyInstance.getClass());
        this._componentType = componentType;
        this._emptyArray = emptyInstance;
        this._hashCode += componentType.hashCode();
        this._fullyTyped = componentType.isFullyTyped();
    }

    public static ArrayType construct(JavaType componentType) {
        Object emptyInstance = Array.newInstance(componentType.getRawClass(), 0);
        return new ArrayType(componentType, emptyInstance);
    }

    protected static void addCommonTypes(Map<String, JavaType> types) {
        Class[] classes;
        for (Class cls : classes = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class, String.class}) {
            SimpleType compType = SimpleType.construct(cls);
            ArrayType arrayType = ArrayType.construct(compType);
            types.put(arrayType.getRawClass().getName(), arrayType);
        }
    }

    @Override
    public boolean isFullyTyped() {
        return this._fullyTyped;
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    public JavaType getComponentType() {
        return this._componentType;
    }

    @Override
    public String toString() {
        return "[array type, component type: " + this._componentType + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ArrayType other = (ArrayType)o;
        return this._componentType.equals(other._componentType);
    }
}

