/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializers;
import org.codehaus.jackson.map.deser.CollectionDeserializer;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.EnumDeserializer;
import org.codehaus.jackson.map.deser.EnumMapDeserializer;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.EnumSetDeserializer;
import org.codehaus.jackson.map.deser.JsonNodeDeserializer;
import org.codehaus.jackson.map.deser.MapDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializers;
import org.codehaus.jackson.map.deser.impl.StringCollectionDeserializer;
import org.codehaus.jackson.map.ext.OptionalHandlerFactory;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicDeserializerFactory
extends DeserializerFactory {
    static final JavaType TYPE_STRING = TypeFactory.type(String.class);
    static final HashMap<JavaType, JsonDeserializer<Object>> _simpleDeserializers = StdDeserializers.constructAll();
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicDeserializerFactory() {
    }

    @Override
    public abstract DeserializerFactory withConfig(DeserializerFactory.Config var1);

    protected abstract JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType var1, DeserializationConfig var2, DeserializerProvider var3, BeanProperty var4, TypeDeserializer var5, JsonDeserializer<?> var6) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType var1, DeserializationConfig var2, DeserializerProvider var3, BasicBeanDescription var4, BeanProperty var5, TypeDeserializer var6, JsonDeserializer<?> var7) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> var1, DeserializationConfig var2, BasicBeanDescription var3, BeanProperty var4) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomMapDeserializer(MapType var1, DeserializationConfig var2, DeserializerProvider var3, BasicBeanDescription var4, BeanProperty var5, KeyDeserializer var6, TypeDeserializer var7, JsonDeserializer<?> var8) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> var1, DeserializationConfig var2, BeanProperty var3) throws JsonMappingException;

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationConfig config, DeserializerProvider p, ArrayType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<?> custom;
        TypeDeserializer elemTypeDeser;
        JavaType elemType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)elemType.getValueHandler();
        if (contentDeser == null) {
            JsonDeserializer<Object> deser = _arrayDeserializers.get(elemType);
            if (deser != null) {
                JsonDeserializer<?> custom2 = this._findCustomArrayDeserializer(type, config, p, property, null, null);
                if (custom2 != null) {
                    return custom2;
                }
                return deser;
            }
            if (elemType.isPrimitive()) {
                throw new IllegalArgumentException("Internal error: primitive type (" + (Object)((Object)type) + ") passed, no array deserializer found");
            }
        }
        if ((elemTypeDeser = (TypeDeserializer)elemType.getTypeHandler()) == null) {
            elemTypeDeser = this.findTypeDeserializer(config, elemType, property);
        }
        if ((custom = this._findCustomArrayDeserializer(type, config, p, property, elemTypeDeser, contentDeser)) != null) {
            return custom;
        }
        if (contentDeser == null) {
            contentDeser = p.findValueDeserializer(config, elemType, property);
        }
        return new ArrayDeserializer(type, contentDeser, elemTypeDeser);
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationConfig config, DeserializerProvider p, CollectionType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<?> custom;
        Class<? extends Collection> collectionClass = type.getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectClassAnnotations(collectionClass);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type, null);
        JavaType contentType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)contentType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config, contentType, property);
        }
        if ((custom = this._findCustomCollectionDeserializer(type, config, p, beanDesc, property, contentTypeDeser, contentDeser)) != null) {
            return custom;
        }
        if (contentDeser == null) {
            if (EnumSet.class.isAssignableFrom(collectionClass)) {
                return new EnumSetDeserializer(this.constructEnumResolver(contentType.getRawClass(), config));
            }
            contentDeser = p.findValueDeserializer(config, contentType, property);
        }
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + (Object)((Object)type));
            }
            collectionClass = fallback;
        }
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor<Collection<Object>> ctor = ClassUtil.findConstructor(collectionClass, fixAccess);
        if (contentType.getRawClass() == String.class) {
            return new StringCollectionDeserializer(type, contentDeser, ctor);
        }
        return new CollectionDeserializer(type, contentDeser, contentTypeDeser, ctor);
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationConfig config, DeserializerProvider p, MapType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<?> custom;
        TypeDeserializer contentTypeDeser;
        Class<? extends Map> mapClass = type.getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectForCreation(type);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type, null);
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        if (keyDes == null) {
            KeyDeserializer keyDeserializer = keyDes = TYPE_STRING.equals((Object)keyType) ? null : p.findKeyDeserializer(config, keyType, property);
        }
        if ((contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler()) == null) {
            contentTypeDeser = this.findTypeDeserializer(config, contentType, property);
        }
        if ((custom = this._findCustomMapDeserializer(type, config, p, beanDesc, property, keyDes, contentTypeDeser, contentDeser)) != null) {
            return custom;
        }
        if (contentDeser == null) {
            contentDeser = p.findValueDeserializer(config, contentType, property);
        }
        if (EnumMap.class.isAssignableFrom(mapClass)) {
            Class kt = keyType.getRawClass();
            if (kt == null || !kt.isEnum()) {
                throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
            }
            return new EnumMapDeserializer(this.constructEnumResolver(kt, config), contentDeser);
        }
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + (Object)((Object)type));
            }
            mapClass = fallback;
            type = (MapType)type.forcedNarrowBy(mapClass);
            beanDesc = (BasicBeanDescription)config.introspectForCreation(type);
        }
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor<Map<Object, Object>> defaultCtor = beanDesc.findDefaultConstructor();
        if (defaultCtor != null && fixAccess) {
            ClassUtil.checkAndFixAccess(defaultCtor);
        }
        MapDeserializer md = new MapDeserializer(type, defaultCtor, keyDes, contentDeser, contentTypeDeser);
        md.setIgnorableProperties(config.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()));
        md.setCreators(this.findMapCreators(config, beanDesc));
        return md;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectForCreation(type);
        JsonDeserializer<Object> des = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (des != null) {
            return des;
        }
        Class enumClass = type.getRawClass();
        JsonDeserializer<?> custom = this._findCustomEnumDeserializer(enumClass, config, beanDesc, property);
        if (custom != null) {
            return custom;
        }
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            Class<?> returnType;
            if (!config.getAnnotationIntrospector().hasCreatorAnnotation(factory)) continue;
            int argCount = factory.getParameterCount();
            if (argCount == 1 && (returnType = factory.getRawType()).isAssignableFrom(enumClass)) {
                return EnumDeserializer.deserializerForCreator(config, enumClass, factory);
            }
            throw new IllegalArgumentException("Unsuitable method (" + factory + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
        }
        return new EnumDeserializer(this.constructEnumResolver(enumClass, config));
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType nodeType, BeanProperty property) throws JsonMappingException {
        Class nodeClass = nodeType.getRawClass();
        JsonDeserializer<?> custom = this._findCustomTreeNodeDeserializer(nodeClass, config, property);
        if (custom != null) {
            return custom;
        }
        return JsonNodeDeserializer.getDeserializer(nodeClass);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = _simpleDeserializers.get(type);
        if (deser != null) {
            return deser;
        }
        Class cls = type.getRawClass();
        if (AtomicReference.class.isAssignableFrom(cls)) {
            StdDeserializer.AtomicReferenceDeserializer d2 = new StdDeserializer.AtomicReferenceDeserializer(type, property);
            return d2;
        }
        JsonDeserializer<Object> d = this.optionalHandlers.findDeserializer(type, config, p);
        if (d != null) {
            return d;
        }
        return null;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig config, JavaType baseType, BeanProperty property) {
        Class cls = baseType.getRawClass();
        BasicBeanDescription bean = (BasicBeanDescription)config.introspectClassAnnotations(cls);
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
            if (b == null) {
                return null;
            }
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        return b.buildTypeDeserializer(baseType, subtypes, property);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig config, JavaType baseType, AnnotatedMember annotated, BeanProperty property) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(annotated, baseType);
        if (b == null) {
            return this.findTypeDeserializer(config, baseType, property);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(annotated, config, ai);
        return b.buildTypeDeserializer(baseType, subtypes, property);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig config, JavaType containerType, AnnotatedMember propertyEntity, BeanProperty property) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(propertyEntity, containerType);
        JavaType contentType = containerType.getContentType();
        if (b == null) {
            return this.findTypeDeserializer(config, contentType, property);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(propertyEntity, config, ai);
        return b.buildTypeDeserializer(contentType, subtypes, property);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationConfig config, Annotated a, BeanProperty property) {
        Object deserDef = config.getAnnotationIntrospector().findDeserializer(a, property);
        if (deserDef != null) {
            return this._constructDeserializer(config, deserDef);
        }
        return null;
    }

    JsonDeserializer<Object> _constructDeserializer(DeserializationConfig config, Object deserDef) {
        if (deserDef instanceof JsonDeserializer) {
            return (JsonDeserializer)deserDef;
        }
        if (!(deserDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
        }
        Class cls = (Class)deserDef;
        if (!JsonDeserializer.class.isAssignableFrom(cls)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + cls.getName() + "; expected Class<JsonDeserializer>");
        }
        return (JsonDeserializer)ClassUtil.createInstance(cls, config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS));
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(DeserializationConfig config, Annotated a, T type, String propName) throws JsonMappingException {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a, (JavaType)type, propName);
        if (subclass != null) {
            try {
                type = type.narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        if (type.isContainerType()) {
            Class<?> cc;
            Class<?> keyClass = intr.findDeserializationKeyType(a, type.getKeyType(), propName);
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)((Object)type)).narrowKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((cc = intr.findDeserializationContentType(a, type.getContentType(), propName)) != null) {
                try {
                    type = type.narrowContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
        }
        return type;
    }

    protected JavaType resolveType(DeserializationConfig config, BasicBeanDescription beanDesc, JavaType type, AnnotatedMember member, BeanProperty property) {
        TypeDeserializer valueTypeDeser;
        if (type.isContainerType()) {
            TypeDeserializer contentTypeDeser;
            Class<? extends JsonDeserializer<?>> cdClass;
            Class<? extends KeyDeserializer> kdClass;
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            boolean canForceAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
            JavaType keyType = type.getKeyType();
            if (keyType != null && (kdClass = intr.findKeyDeserializer(member)) != null && kdClass != KeyDeserializer.None.class) {
                KeyDeserializer kd = ClassUtil.createInstance(kdClass, canForceAccess);
                keyType.setValueHandler((Object)kd);
            }
            if ((cdClass = intr.findContentDeserializer(member)) != null && cdClass != JsonDeserializer.None.class) {
                JsonDeserializer<?> cd = ClassUtil.createInstance(cdClass, canForceAccess);
                type.getContentType().setValueHandler(cd);
            }
            if (member instanceof AnnotatedMember && (contentTypeDeser = this.findPropertyContentTypeDeserializer(config, type, member, property)) != null) {
                type = type.withContentTypeHandler((Object)contentTypeDeser);
            }
        }
        if ((valueTypeDeser = member instanceof AnnotatedMember ? this.findPropertyTypeDeserializer(config, type, member, property) : this.findTypeDeserializer(config, type, null)) != null) {
            type = type.withTypeHandler((Object)valueTypeDeser);
        }
        return type;
    }

    protected EnumResolver<?> constructEnumResolver(Class<?> enumClass, DeserializationConfig config) {
        if (config.isEnabled(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING)) {
            return EnumResolver.constructUnsafeUsingToString(enumClass);
        }
        return EnumResolver.constructUnsafe(enumClass, config.getAnnotationIntrospector());
    }

    protected CreatorContainer findMapCreators(DeserializationConfig config, BasicBeanDescription beanDesc) throws JsonMappingException {
        String name;
        AnnotatedParameter param;
        int i;
        int nameCount;
        SettableBeanProperty[] properties;
        int argCount;
        Class<?> mapClass = beanDesc.getBeanClass();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        CreatorContainer creators = new CreatorContainer(mapClass, fixAccess);
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            argCount = ctor.getParameterCount();
            if (argCount < 1 || !intr.hasCreatorAnnotation(ctor)) continue;
            properties = new SettableBeanProperty[argCount];
            nameCount = 0;
            for (i = 0; i < argCount; ++i) {
                param = ctor.getParameter(i);
                String string = name = param == null ? null : intr.findPropertyNameForParam(param);
                if (name == null || name.length() == 0) {
                    throw new IllegalArgumentException("Parameter #" + i + " of constructor " + ctor + " has no property name annotation: must have for @JsonCreator for a Map type");
                }
                ++nameCount;
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param);
            }
            creators.addPropertyConstructor(ctor, properties);
        }
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            argCount = factory.getParameterCount();
            if (argCount < 1 || !intr.hasCreatorAnnotation(factory)) continue;
            properties = new SettableBeanProperty[argCount];
            nameCount = 0;
            for (i = 0; i < argCount; ++i) {
                param = factory.getParameter(i);
                String string = name = param == null ? null : intr.findPropertyNameForParam(param);
                if (name == null || name.length() == 0) {
                    throw new IllegalArgumentException("Parameter #" + i + " of factory method " + factory + " has no property name annotation: must have for @JsonCreator for a Map type");
                }
                ++nameCount;
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param);
            }
            creators.addPropertyFactory(factory, properties);
        }
        return creators;
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, int index, AnnotatedParameter param) throws JsonMappingException {
        BeanProperty.Std property;
        JavaType t0 = TypeFactory.type(param.getParameterType(), beanDesc.bindingsForBeanType());
        JavaType type = this.resolveType(config, beanDesc, t0, param, property = new BeanProperty.Std(name, t0, beanDesc.getClassAnnotations(), param));
        if (type != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, param, property);
        type = this.modifyTypeByAnnotation(config, param, type, name);
        TypeDeserializer typeDeser = this.findTypeDeserializer(config, type, property);
        SettableBeanProperty.CreatorProperty prop = new SettableBeanProperty.CreatorProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), param, index);
        if (deser != null) {
            prop.setValueDeserializer(deser);
        }
        return prop;
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> value;
            Class<?> key = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> mapValue = value = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(key.getName(), mapValue);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
        _arrayDeserializers = ArrayDeserializers.getAll();
    }
}

