/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.ThrowableDeserializer;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory();

    protected BeanDeserializerFactory() {
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, JavaType type, DeserializerProvider p) throws JsonMappingException {
        JsonDeserializer<Object> deser = super.createBeanDeserializer(config, type, p);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        JsonDeserializer<Object> ad = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo());
        if (ad != null) {
            return ad;
        }
        JavaType newType = this.modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type, null);
        if (newType.getRawClass() != type.getRawClass()) {
            type = newType;
            beanDesc = (BasicBeanDescription)config.introspect(type);
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(config, type, beanDesc);
        }
        return this.buildBeanDeserializer(config, type, beanDesc);
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) throws JsonMappingException {
        BeanDeserializer deser = this.constructBeanDeserializerInstance(config, type, beanDesc);
        this.addDeserializerCreators(config, beanDesc, deser);
        this.addBeanProps(config, beanDesc, deser);
        return deser;
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) throws JsonMappingException {
        SettableBeanProperty prop;
        ThrowableDeserializer deser = this.constructThrowableDeserializerInstance(config, type, beanDesc);
        this.addDeserializerCreators(config, beanDesc, deser);
        this.addBeanProps(config, beanDesc, deser);
        AnnotatedMethod am = beanDesc.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (am != null && (prop = this.constructSettableProperty(config, beanDesc, "cause", am)) != null) {
            deser.addProperty(prop);
        }
        deser.addIgnorable("localizedMessage");
        deser.addIgnorable("message");
        return deser;
    }

    protected BeanDeserializer constructBeanDeserializerInstance(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) {
        return new BeanDeserializer(type);
    }

    protected ThrowableDeserializer constructThrowableDeserializerInstance(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) {
        return new ThrowableDeserializer(type);
    }

    protected void addDeserializerCreators(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializer deser) throws JsonMappingException {
        Constructor<?> defaultCtor;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        if (beanDesc.getType().isConcrete() && (defaultCtor = beanDesc.findDefaultConstructor()) != null) {
            if (fixAccess) {
                ClassUtil.checkAndFixAccess(defaultCtor);
            }
            deser.setDefaultConstructor(defaultCtor);
        }
        VisibilityChecker<?> vchecker = config.getDefaultVisibilityChecker();
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_CREATORS)) {
            vchecker = vchecker.withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        CreatorContainer creators = new CreatorContainer(beanDesc.getBeanClass(), fixAccess);
        this._addDeserializerConstructors(config, beanDesc, vchecker, deser, intr, creators);
        this._addDeserializerFactoryMethods(config, beanDesc, vchecker, deser, intr, creators);
        deser.setCreators(creators);
    }

    protected void _addDeserializerConstructors(DeserializationConfig config, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, BeanDeserializer deser, AnnotationIntrospector intr, CreatorContainer creators) throws JsonMappingException {
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            int argCount = ctor.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation(ctor);
            if (argCount == 1) {
                String name = intr.findPropertyNameForParam(ctor.getParameter(0));
                if (name == null || name.length() == 0) {
                    Class<?> type = ctor.getParameterClass(0);
                    if (type == String.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(ctor)) continue;
                        creators.addStringConstructor(ctor);
                        continue;
                    }
                    if (type == Integer.TYPE || type == Integer.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(ctor)) continue;
                        creators.addIntConstructor(ctor);
                        continue;
                    }
                    if (type == Long.TYPE || type == Long.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(ctor)) continue;
                        creators.addLongConstructor(ctor);
                        continue;
                    }
                    if (!intr.hasCreatorAnnotation(ctor)) continue;
                    creators.addDelegatingConstructor(ctor);
                    continue;
                }
            } else if (!intr.hasCreatorAnnotation(ctor)) continue;
            SettableBeanProperty[] properties = new SettableBeanProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                String name;
                AnnotatedParameter param = ctor.getParameter(i);
                String string = name = param == null ? null : intr.findPropertyNameForParam(param);
                if (name == null || name.length() == 0) {
                    throw new IllegalArgumentException("Argument #" + i + " of constructor " + ctor + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
                }
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param);
            }
            creators.addPropertyConstructor(ctor, properties);
        }
    }

    protected void _addDeserializerFactoryMethods(DeserializationConfig config, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, BeanDeserializer deser, AnnotationIntrospector intr, CreatorContainer creators) throws JsonMappingException {
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            int argCount = factory.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation(factory);
            if (argCount == 1) {
                String name = intr.findPropertyNameForParam(factory.getParameter(0));
                if (name == null || name.length() == 0) {
                    Class<?> type = factory.getParameterClass(0);
                    if (type == String.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(factory)) continue;
                        creators.addStringFactory(factory);
                        continue;
                    }
                    if (type == Integer.TYPE || type == Integer.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(factory)) continue;
                        creators.addIntFactory(factory);
                        continue;
                    }
                    if (type == Long.TYPE || type == Long.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(factory)) continue;
                        creators.addLongFactory(factory);
                        continue;
                    }
                    if (!intr.hasCreatorAnnotation(factory)) continue;
                    creators.addDelegatingFactory(factory);
                    continue;
                }
            } else if (!intr.hasCreatorAnnotation(factory)) continue;
            SettableBeanProperty[] properties = new SettableBeanProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param = factory.getParameter(i);
                String name = intr.findPropertyNameForParam(param);
                if (name == null || name.length() == 0) {
                    throw new IllegalArgumentException("Argument #" + i + " of factory method " + factory + " has no property name annotation; must have when multiple-paramater static method annotated as Creator");
                }
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param);
            }
            creators.addPropertyFactory(factory, properties);
        }
    }

    protected void addBeanProps(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializer deser) throws JsonMappingException {
        VisibilityChecker<?> vchecker = config.getDefaultVisibilityChecker();
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_SETTERS)) {
            vchecker = vchecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        LinkedHashMap<String, AnnotatedMethod> setters = beanDesc.findSetters(vchecker);
        AnnotatedMethod anySetter = beanDesc.findAnySetter();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean ignoreAny = false;
        Boolean B = intr.findIgnoreUnknownProperties(beanDesc.getClassInfo());
        if (B != null) {
            ignoreAny = B;
            deser.setIgnoreUnknownProperties(ignoreAny);
        }
        HashSet<String> ignored = ArrayBuilders.arrayToSet(intr.findPropertiesToIgnore(beanDesc.getClassInfo()));
        if (!ignoreAny && config.isEnabled(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            for (String string : ignored) {
                deser.addIgnorable(string);
            }
            AnnotatedClass ac = beanDesc.getClassInfo();
            for (AnnotatedMethod am : ac.ignoredMemberMethods()) {
                String string = beanDesc.okNameForSetter(am);
                if (string == null) continue;
                deser.addIgnorable(string);
            }
            for (AnnotatedField af : ac.ignoredFields()) {
                deser.addIgnorable(af.getName());
            }
        }
        for (Map.Entry entry : setters.entrySet()) {
            SettableBeanProperty settableBeanProperty;
            String name = (String)entry.getKey();
            if (ignored.contains(name) || (settableBeanProperty = this.constructSettableProperty(config, beanDesc, name, (AnnotatedMethod)entry.getValue())) == null) continue;
            deser.addProperty(settableBeanProperty);
        }
        if (anySetter != null) {
            deser.setAnySetter(this.constructAnySetter(config, anySetter));
        }
        HashSet<String> addedProps = new HashSet<String>(setters.keySet());
        if (config.isEnabled(DeserializationConfig.Feature.USE_GETTERS_AS_SETTERS)) {
            LinkedHashMap<String, AnnotatedMethod> linkedHashMap = beanDesc.findGetters(vchecker, addedProps);
            for (Map.Entry<Object, Object> entry : linkedHashMap.entrySet()) {
                String name;
                AnnotatedMethod getter = (AnnotatedMethod)entry.getValue();
                Class<?> rt = getter.getRawType();
                if (!Collection.class.isAssignableFrom(rt) && !Map.class.isAssignableFrom(rt) || ignored.contains(name = (String)entry.getKey())) continue;
                deser.addProperty(this.constructSetterlessProperty(config, beanDesc, name, getter));
                addedProps.add(name);
            }
        }
        LinkedHashMap<String, AnnotatedField> linkedHashMap = beanDesc.findDeserializableFields(vchecker, addedProps);
        for (Map.Entry<Object, Object> entry : linkedHashMap.entrySet()) {
            SettableBeanProperty prop;
            String name = (String)entry.getKey();
            if (ignored.contains(name) || (prop = this.constructSettableProperty(config, beanDesc, name, (AnnotatedField)entry.getValue())) == null) continue;
            deser.addProperty(prop);
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationConfig config, AnnotatedMethod am) throws JsonMappingException {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            am.fixAccess();
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, am);
        Type rawType = am.getParameterType(1);
        JavaType type = TypeFactory.type(rawType);
        Method m = am.getAnnotated();
        if (deser != null) {
            SettableAnyProperty prop = new SettableAnyProperty(type, m);
            prop.setValueDeserializer(deser);
            return prop;
        }
        type = this.modifyTypeByAnnotation(config, am, type, null);
        return new SettableAnyProperty(type, m);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedMethod setter) throws JsonMappingException {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter.fixAccess();
        }
        JavaType type = this.resolveType(config, beanDesc, setter.getParameterType(0), setter);
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config, setter);
        Method m = setter.getAnnotated();
        type = this.modifyTypeByAnnotation(config, setter, type, name);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.MethodProperty prop = new SettableBeanProperty.MethodProperty(name, type, typeDeser, m);
        if (propDeser != null) {
            prop.setValueDeserializer(propDeser);
        }
        return prop;
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedField field) throws JsonMappingException {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            field.fixAccess();
        }
        JavaType type = this.resolveType(config, beanDesc, field.getGenericType(), field);
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config, field);
        Field f = field.getAnnotated();
        type = this.modifyTypeByAnnotation(config, field, type, name);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.FieldProperty prop = new SettableBeanProperty.FieldProperty(name, type, typeDeser, f);
        if (propDeser != null) {
            prop.setValueDeserializer(propDeser);
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedMethod getter) throws JsonMappingException {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            getter.fixAccess();
        }
        JavaType type = getter.getType(beanDesc.bindingsForBeanType());
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config, getter);
        Method m = getter.getAnnotated();
        type = this.modifyTypeByAnnotation(config, getter, type, name);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.SetterlessProperty prop = new SettableBeanProperty.SetterlessProperty(name, type, typeDeser, m);
        if (propDeser != null) {
            prop.setValueDeserializer(propDeser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }
}

