/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.deser.BaseNodeDeserializer;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    @Deprecated
    public static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class);
    }

    public static JsonDeserializer<? extends JsonNode> getDeserializer(Class<?> nodeClass) {
        if (ObjectNode.class.isAssignableFrom(nodeClass)) {
            return ObjectDeserializer.instance;
        }
        if (ArrayNode.class.isAssignableFrom(nodeClass)) {
            return ArrayDeserializer.instance;
        }
        return instance;
    }

    @Override
    public JsonNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                return this.deserializeObject(jp, ctxt);
            }
            case START_ARRAY: {
                return this.deserializeArray(jp, ctxt);
            }
            case VALUE_STRING: {
                return this._nodeFactory.textNode(jp.getText());
            }
            case VALUE_NUMBER_INT: {
                JsonParser.NumberType nt = jp.getNumberType();
                if (nt == JsonParser.NumberType.BIG_INTEGER || ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_INTEGER_FOR_INTS)) {
                    return this._nodeFactory.numberNode(jp.getIntValue());
                }
                if (nt == JsonParser.NumberType.INT) {
                    return this._nodeFactory.numberNode(jp.getIntValue());
                }
                return this._nodeFactory.numberNode(jp.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                JsonParser.NumberType nt = jp.getNumberType();
                if (nt == JsonParser.NumberType.BIG_DECIMAL || ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return this._nodeFactory.numberNode(jp.getDecimalValue());
                }
                return this._nodeFactory.numberNode(jp.getDoubleValue());
            }
            case VALUE_TRUE: {
                return this._nodeFactory.booleanNode(true);
            }
            case VALUE_FALSE: {
                return this._nodeFactory.booleanNode(false);
            }
            case VALUE_NULL: {
                return this._nodeFactory.nullNode();
            }
        }
        throw ctxt.mappingException(this.getValueClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ArrayDeserializer
    extends BaseNodeDeserializer<ArrayNode> {
        static final ArrayDeserializer instance = new ArrayDeserializer();

        protected ArrayDeserializer() {
            super(ArrayNode.class);
        }

        @Override
        public ArrayNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
                return this.deserializeArray(jp, ctxt);
            }
            throw ctxt.mappingException(ArrayNode.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObjectDeserializer
    extends BaseNodeDeserializer<ObjectNode> {
        static final ObjectDeserializer instance = new ObjectDeserializer();

        protected ObjectDeserializer() {
            super(ObjectNode.class);
        }

        @Override
        public ObjectNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                return this.deserializeObject(jp, ctxt);
            }
            throw ctxt.mappingException(ObjectNode.class);
        }
    }
}

