/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.lang.annotation.Annotation;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationIntrospector {
    public abstract boolean isHandled(Annotation var1);

    public abstract Boolean findCachability(AnnotatedClass var1);

    public abstract Boolean findFieldAutoDetection(AnnotatedClass var1);

    public abstract boolean isIgnorableMethod(AnnotatedMethod var1);

    public abstract boolean isIgnorableConstructor(AnnotatedConstructor var1);

    public abstract boolean isIgnorableField(AnnotatedField var1);

    public abstract Object findSerializer(Annotated var1);

    public abstract JsonSerialize.Inclusion findSerializationInclusion(Annotated var1, JsonSerialize.Inclusion var2);

    public abstract Class<?> findSerializationType(Annotated var1);

    public abstract JsonSerialize.Typing findSerializationTyping(Annotated var1);

    public abstract Boolean findGetterAutoDetection(AnnotatedClass var1);

    public abstract String findGettablePropertyName(AnnotatedMethod var1);

    public abstract boolean hasAsValueAnnotation(AnnotatedMethod var1);

    public abstract String findEnumValue(Enum<?> var1);

    public abstract String findSerializablePropertyName(AnnotatedField var1);

    public abstract Object findDeserializer(Annotated var1);

    public abstract Class<?> findDeserializationType(Annotated var1);

    public abstract Class<?> findDeserializationKeyType(Annotated var1);

    public abstract Class<?> findDeserializationContentType(Annotated var1);

    public abstract Boolean findCreatorAutoDetection(AnnotatedClass var1);

    public abstract Boolean findSetterAutoDetection(AnnotatedClass var1);

    public abstract String findSettablePropertyName(AnnotatedMethod var1);

    public abstract boolean hasAnySetterAnnotation(AnnotatedMethod var1);

    public abstract boolean hasCreatorAnnotation(Annotated var1);

    public abstract String findDeserializablePropertyName(AnnotatedField var1);

    public abstract String findPropertyNameForParam(AnnotatedParameter var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair
    extends AnnotationIntrospector {
        final AnnotationIntrospector _primary;
        final AnnotationIntrospector _secondary;

        public Pair(AnnotationIntrospector p, AnnotationIntrospector s) {
            this._primary = p;
            this._secondary = s;
        }

        @Override
        public boolean isHandled(Annotation ann) {
            return this._primary.isHandled(ann) || this._secondary.isHandled(ann);
        }

        @Override
        public Boolean findCachability(AnnotatedClass ac) {
            Boolean result = this._primary.findCachability(ac);
            if (result == null) {
                result = this._secondary.findCachability(ac);
            }
            return result;
        }

        @Override
        public Boolean findFieldAutoDetection(AnnotatedClass ac) {
            Boolean result = this._primary.findFieldAutoDetection(ac);
            if (result == null) {
                result = this._secondary.findFieldAutoDetection(ac);
            }
            return result;
        }

        @Override
        public boolean isIgnorableMethod(AnnotatedMethod m) {
            return this._primary.isIgnorableMethod(m) || this._secondary.isIgnorableMethod(m);
        }

        @Override
        public boolean isIgnorableConstructor(AnnotatedConstructor c) {
            return this._primary.isIgnorableConstructor(c) || this._secondary.isIgnorableConstructor(c);
        }

        @Override
        public boolean isIgnorableField(AnnotatedField f) {
            return this._primary.isIgnorableField(f) || this._secondary.isIgnorableField(f);
        }

        @Override
        public Object findSerializer(Annotated am) {
            Object result = this._primary.findSerializer(am);
            if (result == null) {
                result = this._secondary.findSerializer(am);
            }
            return result;
        }

        @Override
        public JsonSerialize.Inclusion findSerializationInclusion(Annotated a, JsonSerialize.Inclusion defValue) {
            JsonSerialize.Inclusion v1 = this._primary.findSerializationInclusion(a, defValue);
            JsonSerialize.Inclusion v2 = this._secondary.findSerializationInclusion(a, defValue);
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return v1.compareTo(v2) < 0 ? v2 : v1;
        }

        @Override
        public Class<?> findSerializationType(Annotated a) {
            Class<?> result = this._primary.findSerializationType(a);
            if (result == null) {
                result = this._secondary.findSerializationType(a);
            }
            return result;
        }

        @Override
        public JsonSerialize.Typing findSerializationTyping(Annotated a) {
            JsonSerialize.Typing result = this._primary.findSerializationTyping(a);
            if (result == null) {
                result = this._secondary.findSerializationTyping(a);
            }
            return result;
        }

        @Override
        public Boolean findGetterAutoDetection(AnnotatedClass ac) {
            Boolean result = this._primary.findGetterAutoDetection(ac);
            if (result == null) {
                result = this._secondary.findGetterAutoDetection(ac);
            }
            return result;
        }

        @Override
        public String findGettablePropertyName(AnnotatedMethod am) {
            String str2;
            String result = this._primary.findGettablePropertyName(am);
            if (result == null) {
                result = this._secondary.findGettablePropertyName(am);
            } else if (result.length() == 0 && (str2 = this._secondary.findGettablePropertyName(am)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public boolean hasAsValueAnnotation(AnnotatedMethod am) {
            return this._primary.hasAsValueAnnotation(am) || this._secondary.hasAsValueAnnotation(am);
        }

        @Override
        public String findEnumValue(Enum<?> value) {
            String result = this._primary.findEnumValue(value);
            if (result == null) {
                result = this._secondary.findEnumValue(value);
            }
            return result;
        }

        @Override
        public String findSerializablePropertyName(AnnotatedField af) {
            String str2;
            String result = this._primary.findSerializablePropertyName(af);
            if (result == null) {
                result = this._secondary.findSerializablePropertyName(af);
            } else if (result.length() == 0 && (str2 = this._secondary.findSerializablePropertyName(af)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public Object findDeserializer(Annotated am) {
            Object result = this._primary.findDeserializer(am);
            if (result == null) {
                result = this._secondary.findDeserializer(am);
            }
            return result;
        }

        @Override
        public Class<?> findDeserializationType(Annotated am) {
            Class<?> result = this._primary.findDeserializationType(am);
            if (result == null) {
                result = this._secondary.findDeserializationType(am);
            }
            return result;
        }

        @Override
        public Class<?> findDeserializationKeyType(Annotated am) {
            Class<?> result = this._primary.findDeserializationKeyType(am);
            if (result == null) {
                result = this._secondary.findDeserializationKeyType(am);
            }
            return result;
        }

        @Override
        public Class<?> findDeserializationContentType(Annotated am) {
            Class<?> result = this._primary.findDeserializationContentType(am);
            if (result == null) {
                result = this._secondary.findDeserializationContentType(am);
            }
            return result;
        }

        @Override
        public Boolean findCreatorAutoDetection(AnnotatedClass ac) {
            Boolean result = this._primary.findCreatorAutoDetection(ac);
            if (result == null) {
                result = this._secondary.findCreatorAutoDetection(ac);
            }
            return result;
        }

        @Override
        public Boolean findSetterAutoDetection(AnnotatedClass ac) {
            Boolean result = this._primary.findSetterAutoDetection(ac);
            if (result == null) {
                result = this._secondary.findSetterAutoDetection(ac);
            }
            return result;
        }

        @Override
        public String findSettablePropertyName(AnnotatedMethod am) {
            String str2;
            String result = this._primary.findSettablePropertyName(am);
            if (result == null) {
                result = this._secondary.findSettablePropertyName(am);
            } else if (result.length() == 0 && (str2 = this._secondary.findSettablePropertyName(am)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
            return this._primary.hasAnySetterAnnotation(am) || this._secondary.hasAnySetterAnnotation(am);
        }

        @Override
        public boolean hasCreatorAnnotation(Annotated a) {
            return this._primary.hasCreatorAnnotation(a) || this._secondary.hasCreatorAnnotation(a);
        }

        @Override
        public String findDeserializablePropertyName(AnnotatedField af) {
            String str2;
            String result = this._primary.findDeserializablePropertyName(af);
            if (result == null) {
                result = this._secondary.findDeserializablePropertyName(af);
            } else if (result.length() == 0 && (str2 = this._secondary.findDeserializablePropertyName(af)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public String findPropertyNameForParam(AnnotatedParameter param) {
            String result = this._primary.findPropertyNameForParam(param);
            if (result == null) {
                result = this._secondary.findPropertyNameForParam(param);
            }
            return result;
        }
    }
}

