/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonGetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonSetter;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.annotate.JsonWriteNullProperties;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBeanDescription
extends BeanDescription {
    final AnnotatedClass _classInfo;

    public BasicBeanDescription(Class<?> forClass, AnnotatedClass ac) {
        super(forClass);
        this._classInfo = ac;
    }

    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> acls) {
        return this._classInfo.getAnnotation(acls);
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._classInfo.findMethod(name, paramTypes);
    }

    @Override
    public LinkedHashMap<String, AnnotatedMethod> findGetters(boolean autodetect, Collection<String> ignoredProperties) {
        JsonMethod[] methods;
        JsonAutoDetect cann = this._classInfo.getAnnotation(JsonAutoDetect.class);
        if (cann != null && (methods = cann.value()) != null) {
            autodetect = false;
            for (JsonMethod jm : methods) {
                if (!jm.getterEnabled()) continue;
                autodetect = true;
                break;
            }
        }
        LinkedHashMap<String, AnnotatedMethod> results = new LinkedHashMap<String, AnnotatedMethod>();
        for (AnnotatedMethod am : this._classInfo.getMemberMethods()) {
            AnnotatedMethod old;
            String propName;
            if (this.isIgnored(am) || am.getParameterCount() != 0) continue;
            JsonGetter ann = am.getAnnotation(JsonGetter.class);
            if (ann != null) {
                propName = ann.value();
                if ((propName == null || propName.length() == 0) && (propName = this.okNameForGetter(am)) == null) {
                    propName = am.getName();
                }
            } else if (!autodetect || !am.isPublic() || (propName = this.okNameForGetter(am)) == null) continue;
            if (ignoredProperties != null && ignoredProperties.contains(propName) || (old = results.put(propName, am)) == null) continue;
            String oldDesc = old.getFullName();
            String newDesc = am.getFullName();
            throw new IllegalArgumentException("Conflicting getter definitions for property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public AnnotatedMethod findJsonValue() {
        AnnotatedMethod found = null;
        for (AnnotatedMethod am : this._classInfo.getMemberMethods()) {
            JsonValue ann = am.getAnnotation(JsonValue.class);
            if (ann == null || !ann.value()) continue;
            if (found != null) {
                throw new IllegalArgumentException("Multiple methods with active @JsonValue annotation (" + found.getName() + "(), " + am.getName() + ")");
            }
            if (!am.hasGetterSignature()) {
                throw new IllegalArgumentException("Method " + am.getName() + "() marked with @JsonValue, but does not have valid getter signature (non-static, takes no args, returns a value)");
            }
            found = am;
        }
        return found;
    }

    public Constructor<?> findDefaultConstructor() {
        AnnotatedConstructor ac = this._classInfo.getDefaultConstructor();
        if (ac == null) {
            return null;
        }
        return ac.getAnnotated();
    }

    public Constructor<?> findSingleArgConstructor(Class<?> ... argTypes) {
        for (AnnotatedConstructor ac : this._classInfo.getSingleArgConstructors()) {
            Class<?>[] args = ac.getParameterTypes();
            if (args.length != 1) continue;
            Class<?> actArg = args[0];
            for (Class<?> expArg : argTypes) {
                if (expArg != actArg) continue;
                return ac.getAnnotated();
            }
        }
        return null;
    }

    public Method findFactoryMethod(Class<?> ... expArgTypes) {
        for (AnnotatedMethod am : this._classInfo.getSingleArgStaticMethods()) {
            if (am.getReturnType() != this._class || !am.hasAnnotation(JsonCreator.class) && !"valueOf".equals(am.getName())) continue;
            Class<?> actualArgType = am.getParameterTypes()[0];
            for (Class<?> expArgType : expArgTypes) {
                if (!actualArgType.isAssignableFrom(expArgType)) continue;
                return am.getAnnotated();
            }
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, AnnotatedMethod> findSetters(boolean autodetect) {
        JsonMethod[] methods;
        JsonAutoDetect cann = this._classInfo.getAnnotation(JsonAutoDetect.class);
        if (cann != null && (methods = cann.value()) != null) {
            autodetect = false;
            for (JsonMethod jm : methods) {
                if (!jm.setterEnabled()) continue;
                autodetect = true;
                break;
            }
        }
        LinkedHashMap<String, AnnotatedMethod> results = new LinkedHashMap<String, AnnotatedMethod>();
        for (AnnotatedMethod am : this._classInfo.getMemberMethods()) {
            AnnotatedMethod old;
            String propName;
            if (this.isIgnored(am) || am.getParameterCount() != 1) continue;
            JsonSetter ann = am.getAnnotation(JsonSetter.class);
            if (ann != null) {
                propName = ann.value();
                if ((propName == null || propName.length() == 0) && (propName = this.okNameForSetter(am)) == null) {
                    propName = am.getName();
                }
            } else if (!autodetect || (propName = this.okNameForSetter(am)) == null) continue;
            if ((old = results.put(propName, am)) == null) continue;
            String oldDesc = old.getFullName();
            String newDesc = am.getFullName();
            throw new IllegalArgumentException("Conflicting setter definitions for property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public AnnotatedMethod findAnySetter() throws IllegalArgumentException {
        AnnotatedMethod result = this.findUniqueMethodWith(JsonAnySetter.class);
        if (result != null) {
            int pcount = result.getParameterCount();
            if (pcount != 2) {
                throw new IllegalArgumentException("Invalid annotation @JsonAnySetter on method " + result.getName() + "(): takes " + pcount + " parameters, should take 2");
            }
            Class<?> type = result.getParameterTypes()[0];
            if (type != String.class && type != Object.class) {
                throw new IllegalArgumentException("Invalid annotation @JsonAnySetter on method " + result.getName() + "(): first argument not of type String or Object, but " + type.getName());
            }
        }
        return result;
    }

    public boolean willWriteNullProperties(boolean defValue) {
        JsonWriteNullProperties ann = this.getClassAnnotation(JsonWriteNullProperties.class);
        return ann == null ? defValue : ann.value();
    }

    protected String okNameForGetter(AnnotatedMethod am) {
        String name = am.getName();
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) && this.isCglibGetCallbacks(am)) {
                return null;
            }
            return this.mangleGetterName(am, name.substring(3));
        }
        if (name.startsWith("is")) {
            Class<?> rt = am.getReturnType();
            if (rt != Boolean.class && rt != Boolean.TYPE) {
                return null;
            }
            return this.mangleGetterName(am, name.substring(2));
        }
        return null;
    }

    protected String mangleGetterName(Annotated a, String basename) {
        return BasicBeanDescription.manglePropertyName(basename);
    }

    protected boolean isCglibGetCallbacks(AnnotatedMethod am) {
        Class<?> rt = am.getReturnType();
        if (rt == null || !rt.isArray()) {
            return false;
        }
        Class<?> compType = rt.getComponentType();
        Package pkg = compType.getPackage();
        return pkg != null && pkg.getName().startsWith("net.sf.cglib");
    }

    protected String okNameForSetter(AnnotatedMethod am) {
        String name = am.getName();
        if (name.startsWith("set")) {
            if ((name = this.mangleSetterName(am, name.substring(3))) == null) {
                return null;
            }
            return name;
        }
        return null;
    }

    protected String mangleSetterName(Annotated a, String basename) {
        return BasicBeanDescription.manglePropertyName(basename);
    }

    protected <A extends Annotation> AnnotatedMethod findUniqueMethodWith(Class<A> acls) {
        AnnotatedMethod result = null;
        for (AnnotatedMethod am : this._classInfo.getMemberMethods()) {
            if (!am.hasAnnotation(acls)) continue;
            if (result != null) {
                throw new IllegalArgumentException("Multiple methods with @" + acls.getName() + " annotation (" + result.getName() + "(), " + am.getName() + ")");
            }
            result = am;
        }
        return result;
    }

    protected boolean isIgnored(AnnotatedMethod am) {
        JsonIgnore ann = am.getAnnotation(JsonIgnore.class);
        return ann != null && ann.value();
    }

    public static String manglePropertyName(String basename) {
        char lower;
        char upper;
        int len = basename.length();
        if (len == 0) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < len && (upper = basename.charAt(i)) != (lower = Character.toLowerCase(upper)); ++i) {
            if (sb == null) {
                sb = new StringBuilder(basename);
            }
            sb.setCharAt(i, lower);
        }
        return sb == null ? basename : sb.toString();
    }

    public static String descFor(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return "class " + ((Class)elem).getName();
        }
        if (elem instanceof Method) {
            Method m = (Method)elem;
            return "method " + m.getName() + " (from class " + m.getDeclaringClass().getName() + ")";
        }
        if (elem instanceof Constructor) {
            Constructor ctor = (Constructor)elem;
            return "constructor() (from class " + ctor.getDeclaringClass().getName() + ")";
        }
        return "unknown type [" + elem.getClass() + "]";
    }
}

