/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.JacksonAnnotationFilter;
import org.codehaus.jackson.map.introspect.MethodFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClassIntrospector
extends ClassIntrospector<BasicBeanDescription> {
    public static final BasicClassIntrospector instance = new BasicClassIntrospector();

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig cfg, Class<?> c) {
        MethodFilter mf = this.getGetterMethodFilter(cfg);
        AnnotatedClass ac = AnnotatedClass.constructFull(c, JacksonAnnotationFilter.instance, false, mf);
        return new BasicBeanDescription(c, ac);
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig cfg, Class<?> c) {
        MethodFilter mf = this.getSetterMethodFilter(cfg);
        AnnotatedClass ac = AnnotatedClass.constructFull(c, JacksonAnnotationFilter.instance, true, mf);
        return new BasicBeanDescription(c, ac);
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig cfg, Class<?> c) {
        AnnotatedClass ac = AnnotatedClass.constructFull(c, JacksonAnnotationFilter.instance, true, null);
        return new BasicBeanDescription(c, ac);
    }

    @Override
    public BasicBeanDescription forClassAnnotations(Class<?> c) {
        AnnotatedClass ac = AnnotatedClass.constructFull(c, JacksonAnnotationFilter.instance, false, null);
        return new BasicBeanDescription(c, ac);
    }

    protected MethodFilter getGetterMethodFilter(SerializationConfig cfg) {
        return GetterMethodFilter.instance;
    }

    protected MethodFilter getSetterMethodFilter(DeserializationConfig cfg) {
        return SetterMethodFilter.instance;
    }

    public static final class SetterMethodFilter
    implements MethodFilter {
        public static final SetterMethodFilter instance = new SetterMethodFilter();

        public boolean includeMethod(Method m) {
            if (Modifier.isStatic(m.getModifiers())) {
                return false;
            }
            int pcount = m.getParameterTypes().length;
            switch (pcount) {
                case 0: {
                    Class<?> rt = m.getReturnType();
                    if (!Collection.class.isAssignableFrom(rt) && !Map.class.isAssignableFrom(rt)) break;
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    if (m.getAnnotation(JsonAnySetter.class) == null) break;
                    return true;
                }
            }
            return false;
        }
    }

    public static final class GetterMethodFilter
    implements MethodFilter {
        public static final GetterMethodFilter instance = new GetterMethodFilter();

        private GetterMethodFilter() {
        }

        public boolean includeMethod(Method m) {
            return AnnotatedMethod.hasGetterSignature(m);
        }
    }
}

