/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializationProblemHandler;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.util.LinkedNode;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializer
extends JsonDeserializer<Object>
implements ResolvableDeserializer {
    protected final JavaType _beanType;
    protected Constructor<?> _defaultConstructor;
    protected StringConstructor _stringConstructor;
    protected NumberConstructor _numberConstructor;
    protected final HashMap<String, SettableBeanProperty> _props;
    protected SettableAnyProperty _anySetter;
    protected HashSet<String> _ignorableProps;

    public BeanDeserializer(JavaType type) {
        this._beanType = type;
        this._props = new HashMap();
        this._ignorableProps = null;
    }

    public void setDefaultConstructor(Constructor<?> ctor) {
        this._defaultConstructor = ctor;
    }

    public void setConstructor(StringConstructor ctor) {
        this._stringConstructor = ctor;
    }

    public void setConstructor(NumberConstructor ctor) {
        this._numberConstructor = ctor;
    }

    public void addProperty(SettableBeanProperty prop) {
        SettableBeanProperty old = this._props.put(prop.getPropertyName(), prop);
        if (old != null && old != prop) {
            throw new IllegalArgumentException("Duplicate property '" + prop.getPropertyName() + "' for " + this._beanType);
        }
    }

    public SettableBeanProperty removeProperty(String name) {
        return this._props.remove(name);
    }

    public void setAnySetter(SettableAnyProperty s) {
        if (this._anySetter != null && s != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = s;
    }

    public void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    public void validateConstructors() {
        if (this._defaultConstructor == null && this._numberConstructor == null && this._stringConstructor == null) {
            throw new IllegalArgumentException("Can not create Bean deserializer for (" + this._beanType + "): neither default constructor nor factory methods found");
        }
    }

    @Override
    public void resolve(DeserializationConfig config, DeserializerProvider provider) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> seen = null;
        for (SettableBeanProperty prop : this._props.values()) {
            if (prop.hasValueDeserializer()) continue;
            JavaType type = prop.getType();
            JsonDeserializer<Object> deser = null;
            if (seen != null) {
                deser = (JsonDeserializer<Object>)seen.get(type);
            }
            if (deser == null && (deser = provider.findValueDeserializer(config, type, this._beanType, prop.getPropertyName())) instanceof BeanDeserializer) {
                if (seen == null) {
                    seen = new HashMap<JavaType, JsonDeserializer<Object>>();
                }
                seen.put(type, deser);
            }
            prop.setValueDeserializer(deser);
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            JavaType type = this._anySetter.getType();
            JsonDeserializer<Object> deser = null;
            if (seen != null) {
                deser = (JsonDeserializer<Object>)seen.get(type);
            }
            if (deser == null) {
                deser = provider.findValueDeserializer(config, type, this._beanType, null);
            }
            this._anySetter.setValueDeserializer(deser);
        }
    }

    @Override
    public boolean shouldBeCached() {
        return true;
    }

    @Override
    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object value;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            return this.deserializeFromObject(jp, ctxt);
        }
        if (t == JsonToken.VALUE_STRING && (value = this._stringConstructor.construct(jp.getText())) != null) {
            return value;
        }
        if (t.isNumeric()) {
            value = null;
            switch (jp.getNumberType()) {
                case INT: {
                    value = this._numberConstructor.construct(jp.getIntValue());
                    break;
                }
                case LONG: {
                    value = this._numberConstructor.construct(jp.getLongValue());
                }
            }
            if (value != null) {
                return value;
            }
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public final Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object bean;
        if (this._defaultConstructor == null) {
            throw JsonMappingException.from(jp, "No default constructor found for type " + this._beanType + ": can not instantiate from Json object");
        }
        try {
            bean = this._defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            BeanDeserializer._rethrow(e);
            return null;
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._props.get(propName);
            if (prop != null) {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            JsonToken t = jp.nextToken();
            if (this._anySetter != null) {
                JsonDeserializer<Object> valueDeser = this._anySetter.getValueDeserializer();
                Object value = t == JsonToken.VALUE_NULL ? null : valueDeser.deserialize(jp, ctxt);
                this._anySetter.set(propName, bean, value);
                continue;
            }
            this.handleUnknownProperty(ctxt, bean, propName);
        }
        return bean;
    }

    protected void handleUnknownProperty(DeserializationContext ctxt, Object resultBean, String propName) throws IOException, JsonProcessingException {
        if (this._ignorableProps == null || !this._ignorableProps.contains(propName)) {
            LinkedNode<DeserializationProblemHandler> h = ctxt.getConfig().getProblemHandlers();
            while (h != null) {
                if (!h.value().handleUnknownProperty(ctxt, this, resultBean, propName)) continue;
                return;
            }
            this.reportUnknownField(ctxt, resultBean, propName);
        }
        ctxt.getParser().skipChildren();
    }

    protected void reportUnknownField(DeserializationContext ctxt, Object resultBean, String fieldName) throws IOException, JsonProcessingException {
        throw ctxt.unknownFieldException(resultBean, fieldName);
    }

    protected static void _rethrow(Exception e) throws RuntimeException {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        throw new IllegalArgumentException(t.getMessage(), t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NumberConstructor
    extends ConstructorBase {
        protected final Constructor<?> _intCtor;
        protected final Constructor<?> _longCtor;
        protected final Method _intFactoryMethod;
        protected final Method _longFactoryMethod;

        public NumberConstructor(Class<?> valueClass, Constructor<?> intCtor, Constructor<?> longCtor, Method ifm, Method lfm) {
            super(valueClass);
            this._intCtor = intCtor;
            this._longCtor = longCtor;
            this._intFactoryMethod = ifm;
            this._longFactoryMethod = lfm;
        }

        public Object construct(int value) {
            try {
                if (this._intCtor != null) {
                    return this._intCtor.newInstance(value);
                }
                if (this._intFactoryMethod != null) {
                    return this._intFactoryMethod.invoke((Object)this._valueClass, value);
                }
            }
            catch (Exception e) {
                BeanDeserializer._rethrow(e);
            }
            return this.construct((long)value);
        }

        public Object construct(long value) {
            try {
                if (this._longCtor != null) {
                    return this._longCtor.newInstance(value);
                }
                if (this._longFactoryMethod != null) {
                    return this._longFactoryMethod.invoke((Object)this._valueClass, value);
                }
            }
            catch (Exception e) {
                BeanDeserializer._rethrow(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringConstructor
    extends ConstructorBase {
        protected final Method _factoryMethod;
        protected final Constructor<?> _ctor;

        public StringConstructor(Class<?> valueClass, Constructor<?> ctor, Method factoryMethod) {
            super(valueClass);
            this._ctor = ctor;
            this._factoryMethod = factoryMethod;
        }

        public Object construct(String value) {
            try {
                if (this._ctor != null) {
                    return this._ctor.newInstance(value);
                }
                if (this._factoryMethod != null) {
                    return this._factoryMethod.invoke((Object)this._valueClass, value);
                }
            }
            catch (Exception e) {
                BeanDeserializer._rethrow(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstructorBase {
        protected final Class<?> _valueClass;

        public ConstructorBase(Class<?> valueClass) {
            this._valueClass = valueClass;
        }
    }
}

