/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.Base64Variants;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.DeserializationProblemHandler;
import org.codehaus.jackson.map.util.LinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeserializationConfig {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected LinkedNode<DeserializationProblemHandler> _problemHandlers;

    public DeserializationConfig() {
    }

    protected DeserializationConfig(DeserializationConfig src) {
        this._featureFlags = src._featureFlags;
        this._problemHandlers = src._problemHandlers;
    }

    public DeserializationConfig createUnshared() {
        return new DeserializationConfig(this);
    }

    public void fromAnnotations(Class<?> annotatedClass) {
        JsonAutoDetect autoDetect = annotatedClass.getAnnotation(JsonAutoDetect.class);
        if (autoDetect != null) {
            boolean setters = false;
            boolean creators = false;
            for (JsonMethod m : autoDetect.value()) {
                if (m == JsonMethod.SETTER || m == JsonMethod.ALL) {
                    setters = true;
                }
                if (m != JsonMethod.CREATOR && m != JsonMethod.ALL) continue;
                creators = true;
            }
            this.set(Feature.AUTO_DETECT_SETTERS, setters);
            this.set(Feature.AUTO_DETECT_CREATORS, creators);
        }
    }

    public void addHandler(DeserializationProblemHandler h) {
        if (!LinkedNode.contains(this._problemHandlers, h)) {
            this._problemHandlers = new LinkedNode<DeserializationProblemHandler>(h, this._problemHandlers);
        }
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public Base64Variant getBase64Variant() {
        return Base64Variants.getDefaultVariant();
    }

    public LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        AUTO_DETECT_SETTERS(true),
        AUTO_DETECT_CREATORS(true),
        USE_BIG_DECIMAL_FOR_FLOATS(false);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

